import { ConfluenceApiClient } from "adaptavist-components/lib/common/confluence";

export default class AnalyticsApiClient extends ConfluenceApiClient {
    private servletPath: string;

    constructor({ servletPath }) {
        super();
        this.servletPath = servletPath;
    }

    fetchAnalyticsState = () => {
        const endpoint = `${this.servletPath}/plugins/servlet/adaptavist/forums/analytics`;
        console.warn(`Fetching community forums analytics status from:`, endpoint);

        return this.fetchWithCredentials(endpoint)
            .then(this.handleApiResponse).then( res => {
                console.log("The community forums analytic status is :", res);
                return res;
            })
            .then(res => ({
                // This maps the backend property to a frontend property - the reason for not propagating the change is
                // because analyticsState is hardcoded inside the adaptavist-components library,
                // so changing it there would mean changing it everywhere else it is used, including in CFM's
                // implementation
                analyticsState: res.analyticsEnabled
            }))
    };

    onAnalyticStateChanged = (option) => {
        const endpoint = `${this.servletPath}/plugins/servlet/adaptavist/forums/analytics`;
        console.log("onDisplaySettingChanged", "PUT", endpoint, JSON.stringify({ unspecifiedAction: option }));

        return this.fetchWithCredentials(endpoint, {
            method: 'PUT',
            headers: {
                "Content-Type": "application/json"
            },
            body: JSON.stringify({
                analyticsEnabled: option
            })
        })
    }
}