/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans.search.topics;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.view.beans.search.Pagination;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.Filter;
import com.adaptavist.confluence.forums.view.beans.search.topics.SortOrder;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TopicSearchCriteria
extends SearchCriteria
implements Pagination {
    private final String forumId;
    private final boolean includeSubTopics;
    private final boolean includeLockedTopics;
    private final boolean includeUnlockedTopics;
    private final boolean includeWatchedTopics;
    private final boolean includeHotTopics;
    private final String activityIndicatorThreshold;
    private final String includeTopicsCreatedByUser;
    private final String searchText;
    private final Set<String> searchKeys;
    private final Set<Filter> filters;
    private final String sortKey;
    private final SortOrder sortOrder;
    private final boolean sortStickyOnTop;
    private final boolean searchComments;
    private final int startIndex;
    private final int pageSize;
    private final Set<String> dataItemNames;

    @JsonCreator
    public TopicSearchCriteria(@JsonProperty(value="forumId") String forumId, @JsonProperty(value="includeSubTopics") boolean includeSubTopics, @JsonProperty(value="includeLockedTopics") boolean includeLockedTopics, @JsonProperty(value="includeUnlockedTopics") boolean includeUnlockedTopics, @JsonProperty(value="includeWatchedTopics") boolean includeWatchedTopics, @JsonProperty(value="includeHotTopics") boolean includeHotTopics, @JsonProperty(value="includeTopicsCreatedByUser") String includeTopicsCreatedByUser, @JsonProperty(value="activityIndicatorThreshold") String activityIndicatorThreshold, @JsonProperty(value="searchText") String searchText, @JsonProperty(value="searchKeys") Set<String> searchKeys, @JsonProperty(value="filters") Set<Filter> filters, @JsonProperty(value="sortKey") String sortKey, @JsonProperty(value="sortOrder") String sortOrder, @JsonProperty(value="sortStickyOnTop") boolean sortStickyOnTop, @JsonProperty(value="startIndex") int startIndex, @JsonProperty(value="pageSize") int pageSize, @JsonProperty(value="dataItemNames") Set<String> dataItemNames, @JsonProperty(value="searchComments") boolean searchComments) {
        this.forumId = forumId;
        this.searchText = searchText;
        this.searchKeys = searchKeys;
        this.filters = this.defaultIfEmpty(filters, ForumConstants.SearchDefaults.FILTERS);
        this.includeSubTopics = includeSubTopics;
        this.includeWatchedTopics = includeWatchedTopics;
        this.includeHotTopics = includeHotTopics;
        this.includeTopicsCreatedByUser = includeTopicsCreatedByUser;
        this.activityIndicatorThreshold = activityIndicatorThreshold;
        this.sortKey = this.defaultIfEmpty(sortKey, "lastactivitydate");
        this.sortOrder = SortOrder.from(sortOrder);
        this.sortStickyOnTop = sortStickyOnTop;
        this.searchComments = searchComments;
        this.includeLockedTopics = includeLockedTopics;
        this.includeUnlockedTopics = includeUnlockedTopics;
        this.startIndex = this.defaultIfEmpty(startIndex, this.getDefaultStartIndex());
        this.pageSize = this.defaultIfEmpty(pageSize, this.getDefaultPageSize());
        this.dataItemNames = this.defaultIfEmpty(dataItemNames, ForumConstants.SearchDefaults.DATA_ITEMS);
    }

    @JsonProperty(value="forumId")
    public String getForumId() {
        return this.forumId;
    }

    @JsonProperty(value="includeSubTopics")
    public boolean getIncludeSubTopics() {
        return this.includeSubTopics;
    }

    @JsonProperty(value="includeUnlockedTopics")
    public boolean getIncludeUnlockedTopics() {
        return this.includeUnlockedTopics;
    }

    @JsonProperty(value="includeLockedTopics")
    public boolean getIncludeLockedTopics() {
        return this.includeLockedTopics;
    }

    @JsonProperty(value="activityIndicatorThreshold")
    public String getActivityIndicatorThreshold() {
        return this.activityIndicatorThreshold;
    }

    @JsonProperty(value="includeWatchedTopics")
    public boolean getIncludeWatchedTopics() {
        return this.includeWatchedTopics;
    }

    @JsonProperty(value="includeHotTopics")
    public boolean getIncludeHotTopics() {
        return this.includeHotTopics;
    }

    @JsonProperty(value="includeTopicsCreatedByUser")
    public String getIncludeTopicsCreatedByUser() {
        return this.includeTopicsCreatedByUser;
    }

    @JsonProperty(value="searchText")
    public String getSearchText() {
        return this.searchText;
    }

    @JsonProperty(value="searchKeys")
    public Set<String> getSearchKeys() {
        return this.searchKeys;
    }

    @JsonProperty(value="filters")
    public Set<Filter> getFilters() {
        return this.filters;
    }

    @JsonProperty(value="sortKey")
    public String getSortKey() {
        return this.sortKey;
    }

    @JsonProperty(value="sortOrder")
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @JsonProperty(value="sortStickyOnTop")
    public boolean isSortStickyOnTop() {
        return this.sortStickyOnTop;
    }

    @JsonProperty(value="searchComments")
    public boolean isSearchComments() {
        return this.searchComments;
    }

    @Override
    @JsonProperty(value="startIndex")
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty(value="pageSize")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="dataItemNames")
    public Set<String> getDataItemNames() {
        return this.dataItemNames;
    }

    @JsonIgnore
    public String toString() {
        return "TopicSearchCriteria{forumId='" + this.forumId + "', searchText='" + this.searchText + "', searchKeys=" + this.searchKeys + ", includeSubTopics=" + this.includeSubTopics + ", includeLockedTopics=" + this.includeLockedTopics + ", includeUnlockedTopics=" + this.includeUnlockedTopics + ", includeWatchedTopics=" + this.includeWatchedTopics + ", includeHotTopics=" + this.includeHotTopics + ", includeTopicsCreatedByUser=" + this.includeTopicsCreatedByUser + ", filters=" + this.filters + ", sortKey='" + this.sortKey + "', sortOrder=" + this.sortOrder + ", startIndex=" + this.getStartIndex() + ", pageSize=" + this.getPageSize() + ", dataItemNames=" + this.dataItemNames + ", searchComments=" + this.searchComments + "}";
    }
}

