/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans;

import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Status {
    private static final Status EMPTY = new Status();
    private final boolean forum;
    private final boolean subForum;
    private final boolean topic;
    private final boolean locked;
    private final boolean sticky;

    private Status() {
        this(false, false, false, false, false);
    }

    @JsonCreator
    public Status(@JsonProperty(value="forum") boolean forum, @JsonProperty(value="subForum") boolean subForum, @JsonProperty(value="topic") boolean topic, @JsonProperty(value="locked") boolean locked, @JsonProperty(value="sticky") boolean sticky) {
        this.forum = forum;
        this.subForum = subForum;
        this.topic = topic;
        this.locked = locked;
        this.sticky = sticky;
    }

    public static Status from(PageStatusManager.PageStatus pageStatus) {
        if (pageStatus == null) {
            return EMPTY;
        }
        return new Status(pageStatus.isForum(), pageStatus.isSubForum(), pageStatus.isTopic(), pageStatus.isLocked(), pageStatus.isSticky());
    }

    @JsonProperty(value="forum")
    public boolean isForum() {
        return this.forum;
    }

    @JsonProperty(value="subForum")
    public boolean isSubForum() {
        return this.subForum;
    }

    @JsonProperty(value="topic")
    public boolean isTopic() {
        return this.topic;
    }

    @JsonProperty(value="locked")
    public boolean isLocked() {
        return this.locked;
    }

    @JsonProperty(value="sticky")
    public boolean isSticky() {
        return this.sticky;
    }

    @JsonIgnore
    public String toString() {
        String status = "";
        status = this.append(status, this.forum, "isForum");
        status = this.append(status, this.subForum, "isSubForum");
        status = this.append(status, this.topic, "isTopic");
        status = this.append(status, this.locked, "isLocked");
        return StringUtils.isNotBlank((String)(status = this.append(status, this.sticky, "isSticky"))) ? String.format("Status { %s } ", status) : status;
    }

    private String append(String destination, boolean condition, String toAppend) {
        if (condition) {
            return StringUtils.isBlank((String)destination) ? toAppend : destination + " " + toAppend;
        }
        return destination;
    }
}

