/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.impl.PermissionsSupport;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.impl.AbstractSpaceKeyValidator;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpacePermissionValidator
extends AbstractSpaceKeyValidator {
    private final PermissionsSupport permissionsSupport;

    @Autowired
    public SpacePermissionValidator(PermissionsSupport permissionsSupport, @ComponentImport SpaceManager spaceManager) {
        super(spaceManager);
        this.permissionsSupport = permissionsSupport;
    }

    @Override
    protected ValidationReport validateSpaceKeys(Set<String> spaceKeys) {
        ValidationReport report = ValidationReport.success();
        for (String spaceKey : spaceKeys) {
            if (!StringUtils.isNotBlank((String)spaceKey) || this.permissionsSupport.hasViewSpacePermission((User)AuthenticatedUserThreadLocal.get(), this.getSpace(spaceKey))) continue;
            report = ValidationReport.combineAll(report, ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.macro.no.permission", new Serializable[0]), new ValidationReport[0]);
        }
        return report;
    }
}

