/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.results.impl;

import com.adaptavist.confluence.forums.model.datatypes.DataItemType;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeValues;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import com.adaptavist.confluence.forums.service.search.results.SearchResultsConverter;
import com.adaptavist.confluence.forums.view.beans.ForumContent;
import com.adaptavist.confluence.forums.view.beans.ForumStatusUpdate;
import com.adaptavist.confluence.forums.view.beans.Topic;
import com.adaptavist.confluence.forums.view.beans.TopicContent;
import com.adaptavist.confluence.forums.view.beans.TopicData;
import com.adaptavist.confluence.forums.view.beans.User;
import com.adaptavist.confluence.forums.view.beans.search.content.ForumContentSearchResults;
import com.adaptavist.confluence.forums.view.beans.search.content.TopicContentSearchResults;
import com.adaptavist.confluence.forums.view.beans.search.topics.SortOrder;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchResults;
import com.atlassian.confluence.pages.NaturalStringComparator;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchResultsConverter
implements SearchResultsConverter {
    public static final String VIEWED = "viewed";
    public static final String CREATED_NEW = "createdNew";
    public static final String ANONYMOUS = "anonymous";
    private static final int NEW_TOPIC_TIME_WINDOW = 7;
    private final DataTypeManager dataTypeManager;
    private final RecentlyViewedManager recentlyViewedManager;

    @Autowired
    public DefaultSearchResultsConverter(DataTypeManager dataTypeManager, @ComponentImport RecentlyViewedManager recentlyViewedManager) {
        this.dataTypeManager = dataTypeManager;
        this.recentlyViewedManager = recentlyViewedManager;
    }

    @Override
    public TopicSearchResults topicResults(SearchResultAccessors results, TopicSearchCriteria searchCriteria) {
        ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
        Map<Long, Date> viewedPagesWithTitleAndDate = this.getViewedPages(authenticatedUser);
        ArrayList<Topic> topics = new ArrayList<Topic>(results.size());
        for (SearchResultAccessor resultAccessor : results) {
            Date lastViewedDateForTopic = viewedPagesWithTitleAndDate.get(resultAccessor.getId());
            Topic topic = this.createTopic(resultAccessor, this.dataTypeManager.getDataItemTypes(searchCriteria.getDataItemNames()), lastViewedDateForTopic, authenticatedUser == null ? ANONYMOUS : authenticatedUser.getName());
            topics.add(topic);
        }
        if (searchCriteria.getSortKey() != null && searchCriteria.getSortKey().equals("title")) {
            NaturalStringComparator comparator = new NaturalStringComparator();
            List<Topic> sortedByTitle = topics.stream().sorted((o1, o2) -> {
                Map<String, TopicData> data1 = o1.getData();
                Map<String, TopicData> data2 = o2.getData();
                if (data1.get("status").getValues().get("stickyTopic").equals(true) || data2.get("status").getValues().get("stickyTopic").equals(true)) {
                    return 1;
                }
                if (searchCriteria.getSortOrder().equals((Object)SortOrder.ASC)) {
                    return comparator.compare((String)data1.get("title").getValues().get("title"), (String)data2.get("title").getValues().get("title"));
                }
                return comparator.compare((String)data2.get("title").getValues().get("title"), (String)data1.get("title").getValues().get("title"));
            }).collect(Collectors.toList()).subList(searchCriteria.getStartIndex(), Math.min(results.getUnfilteredResultsCount(), searchCriteria.getStartIndex() + searchCriteria.getPageSize()));
            return new TopicSearchResults(results.getUnfilteredResultsCount(), searchCriteria.getStartIndex(), sortedByTitle);
        }
        return new TopicSearchResults(results.getUnfilteredResultsCount(), searchCriteria.getStartIndex(), topics);
    }

    @Override
    public ForumStatusUpdate getForumStatusUpdate(SearchResultAccessors results, TopicSearchCriteria searchCriteria) {
        int newCreatedTopics = 0;
        int changedTopics = 0;
        ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
        Map<Long, Date> viewedPagesWithTitleAndDate = this.getViewedPages(authenticatedUser);
        String username = authenticatedUser.getName();
        for (SearchResultAccessor resultAccessor : results) {
            Date lastViewedDateForTopic;
            if (this.isTopicNew(resultAccessor, lastViewedDateForTopic = viewedPagesWithTitleAndDate.get(resultAccessor.getId()), username)) {
                ++newCreatedTopics;
                continue;
            }
            if (!this.isTopicUpdated(resultAccessor, lastViewedDateForTopic, username)) continue;
            ++changedTopics;
        }
        return new ForumStatusUpdate(newCreatedTopics, changedTopics);
    }

    @Override
    public TopicContentSearchResults topicResults(SearchResultAccessors results, int startIndex) {
        ArrayList<TopicContent> topics = new ArrayList<TopicContent>(results.size());
        for (SearchResultAccessor resultAccessor : results) {
            topics.add(this.topicContent(resultAccessor));
        }
        return new TopicContentSearchResults(results.getUnfilteredResultsCount(), startIndex, (List<TopicContent>)topics);
    }

    @Override
    public ForumContentSearchResults forumResults(SearchResultAccessors results, int startIndex, Map<Long, SearchResultAccessors> forumTopics) {
        ArrayList<ForumContent> forums = new ArrayList<ForumContent>(results.size());
        for (SearchResultAccessor forumAccessor : results) {
            forums.add(this.forumContent(forumAccessor, forumTopics.get(forumAccessor.getId())));
        }
        return new ForumContentSearchResults(results.getUnfilteredResultsCount(), startIndex, (List<ForumContent>)forums);
    }

    private Topic createTopic(SearchResultAccessor resultAccessor, Set<DataItemType> dataTypes, Date lastViewedDateForTopic, String username) {
        HashMap<String, TopicData> data = new HashMap<String, TopicData>();
        if (!username.equals(ANONYMOUS)) {
            if (this.isTopicNew(resultAccessor, lastViewedDateForTopic, username)) {
                data.put(VIEWED, new TopicData(Collections.singletonMap(VIEWED, false)));
                data.put(CREATED_NEW, new TopicData(Collections.singletonMap(CREATED_NEW, true)));
            } else {
                data.put(VIEWED, new TopicData(Collections.singletonMap(VIEWED, !this.isTopicUpdated(resultAccessor, lastViewedDateForTopic, username))));
                data.put(CREATED_NEW, new TopicData(Collections.singletonMap(CREATED_NEW, false)));
            }
        } else {
            data.put(VIEWED, new TopicData(Collections.singletonMap(VIEWED, true)));
            data.put(CREATED_NEW, new TopicData(Collections.singletonMap(CREATED_NEW, false)));
        }
        for (DataItemType dataItemType : dataTypes) {
            String itemName = dataItemType.getName();
            DataTypeValues itemValues = dataItemType.getData(resultAccessor);
            data.put(itemName, new TopicData(itemValues.getValuesAsMap()));
        }
        return new Topic(resultAccessor.getId(), data);
    }

    private boolean isTopicUpdated(SearchResultAccessor resultAccessor, Date lastViewedDateForTopic, String username) {
        Date lastActivityDateForTopic = new Date(Long.parseLong(resultAccessor.getSearchResult().getField("forumIndexPageLastActivityDate")));
        return lastViewedDateForTopic == null || lastViewedDateForTopic.before(lastActivityDateForTopic) && !resultAccessor.getSearchResult().getField("forumIndexLastActivityAuthor").equals(username);
    }

    private boolean isTopicNew(SearchResultAccessor resultAccessor, Date lastViewedDateForTopic, String username) {
        Date topicCreationDate = new Date(Long.parseLong(resultAccessor.getSearchResult().getField("forumIndexPageCreationDate")));
        if (resultAccessor.getSearchResult().getField("forumIndexPageAuthorUsername") == null) {
            return new Date().before(this.addDaysToDate(topicCreationDate, 7)) && lastViewedDateForTopic == null;
        }
        return new Date().before(this.addDaysToDate(topicCreationDate, 7)) && lastViewedDateForTopic == null && !resultAccessor.getSearchResult().getField("forumIndexPageAuthorUsername").equals(username);
    }

    private Date addDaysToDate(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    private TopicContent topicContent(SearchResultAccessor topicAccessor) {
        long id = topicAccessor.getId();
        String title = topicAccessor.getDisplayTitle();
        long forumId = topicAccessor.getLong("forumIndexTopicForumId", 0L);
        String forumTitle = topicAccessor.getString("forumIndexTopicForumTitle", "");
        String excerpt = topicAccessor.getExcerpt();
        int replies = topicAccessor.getInt("forumIndexPageNumberOfReplies", 0);
        long created = this.getCreationDate(topicAccessor);
        User author = topicAccessor.getCreatorUser();
        long lastActivityDate = this.getLastActivityDate(topicAccessor);
        User lastModifier = topicAccessor.getUser("forumIndexLastActivityAuthor");
        boolean isSticky = topicAccessor.getBoolean("forumIndexPageIsSticky");
        boolean isLocked = topicAccessor.getBoolean("forumIndexPageIsLocked");
        int activityScore = topicAccessor.getInt("forumIndexPageActivityScore", 0);
        return new TopicContent(id, title, forumId, forumTitle, excerpt, author, created, replies, lastActivityDate, lastModifier, isSticky, isLocked, activityScore);
    }

    private ForumContent forumContent(SearchResultAccessor forumAccessor, SearchResultAccessors forumTopics) {
        long id = forumAccessor.getId();
        String title = forumAccessor.getDisplayTitle();
        String excerpt = forumAccessor.getExcerpt();
        User author = forumAccessor.getCreatorUser();
        long created = this.getCreationDate(forumAccessor);
        int topics = forumTopics.size();
        int replies = this.getRepliesCount(forumAccessor, forumTopics);
        long lastActivityDate = this.getLastActivityDate(forumAccessor);
        User lastModifier = forumAccessor.getUser("forumIndexLastActivityAuthor");
        if (forumTopics.size() > 0) {
            lastActivityDate = this.getLastCommentOnTopics(forumTopics);
            lastModifier = forumTopics.getFirst().getUser("forumIndexLastActivityAuthor");
        }
        return new ForumContent(id, title, excerpt, author, created, topics, replies, lastActivityDate, lastModifier);
    }

    private int getRepliesCount(SearchResultAccessor forumResultAccessor, SearchResultAccessors forumTopics) {
        int replies = forumResultAccessor.getInt("forumIndexPageNumberOfReplies", 0);
        for (SearchResultAccessor topic : forumTopics) {
            replies += topic.getInt("forumIndexPageNumberOfReplies", 0);
        }
        return replies;
    }

    private long getLastCommentOnTopics(SearchResultAccessors forumTopics) {
        long lastDate = 0L;
        for (SearchResultAccessor topic : forumTopics) {
            long lastActivityDate = topic.getLong("forumIndexPageLastActivityDate");
            if (lastActivityDate <= lastDate) continue;
            lastDate = lastActivityDate;
        }
        return lastDate;
    }

    private long getLastActivityDate(SearchResultAccessor accessor) {
        return accessor.getLong("forumIndexPageLastActivityDate", accessor.getLastModificationDate().getTime());
    }

    private long getCreationDate(SearchResultAccessor accessor) {
        return accessor.getLong("forumIndexPageCreationDate", accessor.getCreationDate().getTime());
    }

    private Map<Long, Date> getViewedPages(ConfluenceUser authenticatedUser) {
        if (authenticatedUser != null) {
            HashMap<Long, Date> recentlyViewedTitleAndDate = new HashMap<Long, Date>();
            List recentlyViewed = this.recentlyViewedManager.getRecentlyViewed(authenticatedUser.getKey().getStringValue(), Integer.MAX_VALUE);
            for (RecentlyViewed item : recentlyViewed) {
                recentlyViewedTitleAndDate.put(item.getId(), new Date(item.getLastSeen()));
            }
            return recentlyViewedTitleAndDate;
        }
        return new HashMap<Long, Date>();
    }
}

