/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.results.impl;

import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class DefaultSearchResultAccessor
implements SearchResultAccessor {
    private static final String ANONYMOUS = "anonymous";
    private static final com.adaptavist.confluence.forums.view.beans.User ANONYMOUS_USER = new com.adaptavist.confluence.forums.view.beans.User("anonymous", "anonymous", null, "/images/icons/profilepics/anonymous.png");
    private final UserAccessor userAccessor;
    private final SearchResult searchResult;

    public DefaultSearchResultAccessor(UserAccessor userAccessor, SearchResult searchResult) {
        this.userAccessor = userAccessor;
        this.searchResult = searchResult;
    }

    @Override
    public long getId() {
        return ((HibernateHandle)this.searchResult.getHandle()).getId();
    }

    @Override
    public String getDisplayTitle() {
        return this.searchResult.getDisplayTitle();
    }

    @Override
    public String getExcerpt() {
        return this.getString("forumTopicExcerptMacroContent", this.getString("excerpt", ""));
    }

    @Override
    public SearchResult getSearchResult() {
        return this.searchResult;
    }

    @Override
    public com.adaptavist.confluence.forums.view.beans.User getCreatorUser() {
        return this.getForumUser(this.searchResult.getCreatorUser());
    }

    @Override
    public Date getCreationDate() {
        return this.searchResult.getCreationDate();
    }

    @Override
    public Date getLastModificationDate() {
        return this.searchResult.getLastModificationDate();
    }

    @Override
    public String getString(String fieldName) {
        return this.searchResult.getField(fieldName);
    }

    @Override
    public String getString(String fieldName, String defaultValue) {
        return this.defaultValue(this.searchResult.getField(fieldName), defaultValue);
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return Boolean.parseBoolean(this.searchResult.getField(fieldName));
    }

    @Override
    public boolean getBoolean(String fieldName, boolean defaultValue) {
        return Boolean.parseBoolean(this.defaultValue(this.searchResult.getField(fieldName), String.valueOf(defaultValue)));
    }

    @Override
    public Integer getInt(String fieldName) {
        String value = this.searchResult.getField(fieldName);
        return StringUtils.isNumeric((String)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
    }

    @Override
    public int getInt(String fieldName, int defaultValue) {
        return this.defaultValue(this.getInt(fieldName), defaultValue);
    }

    @Override
    public Long getLong(String fieldName) {
        String value = this.searchResult.getField(fieldName);
        return StringUtils.isNumeric((String)value) ? Long.valueOf(Long.parseLong(value)) : null;
    }

    @Override
    public long getLong(String fieldName, long defaultValue) {
        return this.defaultValue(this.getLong(fieldName), defaultValue);
    }

    @Override
    public Date getDate(String fieldName) {
        String value = this.searchResult.getField(fieldName);
        return StringUtils.isNumeric((String)value) ? new Date(Long.parseLong(value)) : null;
    }

    @Override
    public Date getDate(String fieldName, Date defaultValue) {
        return this.defaultValue(this.getDate(fieldName), defaultValue);
    }

    @Override
    public com.adaptavist.confluence.forums.view.beans.User getUser(String fieldName) {
        String username = this.searchResult.getField(fieldName);
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        return this.getForumUser(user);
    }

    private com.adaptavist.confluence.forums.view.beans.User getForumUser(ConfluenceUser user) {
        if (user != null) {
            ProfilePictureInfo picture = this.userAccessor.getUserProfilePicture((User)user);
            String picUrl = picture != null ? picture.getDownloadPath() : "/images/icons/profilepics/anonymous.png";
            return new com.adaptavist.confluence.forums.view.beans.User(user.getName(), user.getFullName(), user.getKey().getStringValue(), picUrl);
        }
        return ANONYMOUS_USER;
    }

    private <T> T defaultValue(T initial, T defaultValue) {
        return initial == null ? defaultValue : initial;
    }
}

