/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.LockedActionManager;
import com.adaptavist.confluence.forums.view.macros.velocity.VelocityTemplateResolver;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.WebResourceManager;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultLockedActionManager
implements LockedActionManager {
    private static final String ACTION = "action";
    private static final String LOCKED_FORUM = "forum/templates/vm/locking/locked-forum.vm";
    private static final String LOCKED_TOPIC = "forum/templates/vm/locking/locked-topic.vm";
    private static final String LOCKED_FORUM_ATTACH = "forum/templates/vm/locking/locked-forum-attach.vm";
    private static final String LOCKED_TOPIC_ATTACH = "forum/templates/vm/locking/locked-topic-attach.vm";
    private static final String LOCKED_COMMENT = "forum/templates/vm/locking/locked-comment-error.vm";
    private final ForumManager forumManager;
    private final WebResourceManager webResourceManager;
    private final VelocityTemplateResolver velocityTemplateResolver;

    @Autowired
    public DefaultLockedActionManager(VelocityTemplateResolver velocityTemplateResolver, ForumManager forumManager, @ComponentImport WebResourceManager webResourceManager) {
        this.forumManager = forumManager;
        this.webResourceManager = webResourceManager;
        this.velocityTemplateResolver = velocityTemplateResolver;
    }

    @Override
    public void addLockedActionInfoMessage(AbstractPage page, ConfluenceActionSupport action, LockedActionManager.ActionName actionName) {
        String messageInfo = this.getLockedPageInfoMessage(page, action, actionName);
        if (StringUtils.isNotBlank((String)messageInfo)) {
            action.getMessageHolder().addActionInfo(messageInfo, new Object[0]);
        }
    }

    @Override
    public void addLockedCommentActionErrorMessage(AbstractPage page, ConfluenceActionSupport action) {
        String messageInfo = this.fromTemplate(LOCKED_COMMENT, action);
        if (StringUtils.isNotBlank((String)messageInfo)) {
            action.getMessageHolder().addActionError(messageInfo);
        }
    }

    @Override
    public void loadLockedPageRequiredResources(LockedActionManager.ActionName actionName) {
        this.webResourceManager.requireResource(actionName.getResourceName());
    }

    @Override
    public boolean isPageActionLocked(AbstractPage page) {
        return page != null && this.forumManager.isPageLocked(page);
    }

    private String getLockedPageInfoMessage(AbstractPage page, ConfluenceActionSupport action, LockedActionManager.ActionName actionName) {
        if (this.forumManager.isTopic(page)) {
            return this.topicMessage(action, actionName);
        }
        if (page instanceof Page && this.forumManager.isForum((Page)page)) {
            return this.forumMessage(action, actionName);
        }
        return null;
    }

    private String topicMessage(ConfluenceActionSupport action, LockedActionManager.ActionName actionName) {
        String template = LockedActionManager.ActionName.VIEW_PAGE.equals((Object)actionName) ? LOCKED_TOPIC : LOCKED_TOPIC_ATTACH;
        return this.fromTemplate(template, action);
    }

    private String forumMessage(ConfluenceActionSupport action, LockedActionManager.ActionName actionName) {
        String template = LockedActionManager.ActionName.VIEW_PAGE.equals((Object)actionName) ? LOCKED_FORUM : LOCKED_FORUM_ATTACH;
        return this.fromTemplate(template, action);
    }

    private String fromTemplate(String template, ConfluenceActionSupport actionSupport) {
        return this.velocityTemplateResolver.resolveTemplate(template).withContext(VelocityContextBuilder.contextBuilder().put(ACTION, actionSupport));
    }
}

