/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.module;

import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.model.module.impl.DataItemTypeModuleDescriptor;
import com.adaptavist.confluence.forums.model.module.impl.SearchKeysIndexMapperModuleDescriptor;
import com.adaptavist.confluence.forums.model.module.impl.SearchSorterModuleDescriptor;
import com.adaptavist.confluence.forums.service.search.SearchKeyIndexResolver;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginEventListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DataTypeManager dataTypeManager;
    private final SearchKeyIndexResolver searchKeyIndexResolver;
    private final ForumSearchSortManager forumSearchSortManager;

    public PluginEventListener(@ComponentImport EventPublisher eventPublisher, DataTypeManager dataTypeManager, SearchKeyIndexResolver searchKeyIndexResolver, ForumSearchSortManager forumSearchSortManager) {
        this.dataTypeManager = dataTypeManager;
        this.searchKeyIndexResolver = searchKeyIndexResolver;
        this.forumSearchSortManager = forumSearchSortManager;
        eventPublisher.register((Object)this);
    }

    private boolean hasModuleDescriptorOfClass(Plugin plugin, Class clazz) {
        List modules = plugin.getModuleDescriptorsByModuleClass(clazz);
        return modules != null && !modules.isEmpty();
    }

    private void flushCaches(Plugin plugin) {
        if (this.hasModuleDescriptorOfClass(plugin, DataItemTypeModuleDescriptor.class)) {
            this.dataTypeManager.flushCaches();
        }
        if (this.hasModuleDescriptorOfClass(plugin, SearchKeysIndexMapperModuleDescriptor.class)) {
            this.searchKeyIndexResolver.flushCaches();
        }
        if (this.hasModuleDescriptorOfClass(plugin, SearchSorterModuleDescriptor.class)) {
            this.forumSearchSortManager.flushCaches();
        }
    }

    @EventListener
    public void handlePluginEnabledEvent(PluginEnabledEvent event) {
        this.flushCaches(event.getPlugin());
    }

    @EventListener
    public void handlePluginDisabledEvent(PluginDisabledEvent event) {
        this.flushCaches(event.getPlugin());
    }

    @EventListener
    public void handlePluginRefreshedEvent(PluginRefreshedEvent event) {
        this.flushCaches(event.getPlugin());
    }

    @EventListener
    public void handlePluginUninstalledEvent(PluginUninstalledEvent event) {
        this.flushCaches(event.getPlugin());
    }

    @EventListener
    public void handlePluginUpgradedEvent(PluginUpgradedEvent event) {
        this.flushCaches(event.getPlugin());
    }

    private void flushCaches(ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor instanceof DataItemTypeModuleDescriptor) {
            this.dataTypeManager.flushCaches();
        }
        if (moduleDescriptor instanceof SearchKeysIndexMapperModuleDescriptor) {
            this.searchKeyIndexResolver.flushCaches();
        }
        if (moduleDescriptor instanceof SearchSorterModuleDescriptor) {
            this.forumSearchSortManager.flushCaches();
        }
    }

    @EventListener
    public void handlePluginModuleDisabledEvent(PluginModuleDisabledEvent event) {
        this.flushCaches(event.getModule());
    }

    @EventListener
    public void handlePluginModuleEnabledEvent(PluginModuleEnabledEvent event) {
        this.flushCaches(event.getModule());
    }
}

