/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model;

import com.atlassian.core.util.DateUtils;

public class ActivityScoreDateMultiplier {
    private final int dateValue;
    private final DatePeriod datePeriod;
    private final double multiplier;

    public ActivityScoreDateMultiplier(int dateValue, DatePeriod datePeriod, double multiplier) {
        this.dateValue = dateValue;
        this.datePeriod = datePeriod;
        this.multiplier = multiplier;
    }

    public long getDateValueAsMillis() {
        return (long)this.dateValue * this.datePeriod.getMillis();
    }

    public int getDateValue() {
        return this.dateValue;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public DatePeriod getDatePeriod() {
        return this.datePeriod;
    }

    public static enum DatePeriod {
        MINUTES(DateUtils.MINUTE_MILLIS),
        HOURS(DateUtils.HOUR_MILLIS),
        DAYS(DateUtils.DAY_MILLIS),
        MONTHS(DateUtils.MONTH_MILLIS);

        private long millis;

        private DatePeriod(long millis) {
            this.millis = millis;
        }

        private long getMillis() {
            return this.millis;
        }
    }
}

