/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class CommentReindexPageListener
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private ConfluenceIndexer indexer;
    private static final Logger LOG = LoggerFactory.getLogger(CommentReindexPageListener.class);

    public CommentReindexPageListener(@ComponentImport EventPublisher eventPublisher, @ComponentImport ConfluenceIndexer indexer) {
        this.eventPublisher = eventPublisher;
        this.indexer = indexer;
    }

    @EventListener
    public void commentEvent(CommentEvent commentEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("caught event: " + commentEvent);
        }
        ContentEntityObject ceo = commentEvent.getComment().getContainer();
        this.indexer.reIndex((Searchable)ceo);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

