/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.condition;

import com.adaptavist.confluence.forums.controller.condition.AbstractLicensedCondition;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import org.springframework.beans.factory.annotation.Qualifier;

public class ForumLockedCondition
extends AbstractLicensedCondition {
    private final ForumManager forumManager;

    public ForumLockedCondition(@Qualifier(value="licensingSupport") LicensingSupport licensingSupport, ForumManager forumManager) {
        super(licensingSupport);
        this.forumManager = forumManager;
    }

    @Override
    public boolean shouldDisplay(Page page) {
        return this.isForumOrTopic(page) && this.isParentLocked(page.getParent());
    }

    private boolean isForumOrTopic(Page page) {
        return this.forumManager.isForum(page) || this.forumManager.isTopic((AbstractPage)page);
    }

    private boolean isParentLocked(Page page) {
        if (page == null) {
            return false;
        }
        if (this.forumManager.isForum(page)) {
            return this.forumManager.isPageLocked((AbstractPage)page);
        }
        return this.isParentLocked(page.getParent());
    }
}

