/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.config;

import com.adaptavist.confluence.forums.controller.action.config.SpaceAdminConfigAction;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;

public class SpaceForumListAction
extends SpaceAdminConfigAction {
    private static final String SPACE_COMMUNITY_FORUMS_SUMMARY = "Space community forums list";
    private static final String EMPTY_TEMPLATE = "<at:declarations/>";
    private XhtmlContent xhtmlContent;
    private PageTemplateManager templateManager;
    private VelocityHelperService velocityHelperService;

    public String spaceForumList() {
        if (this.noSpaceSpecified()) {
            return "error";
        }
        if (this.isNotSpaceAdmin()) {
            return "accessDenied";
        }
        if (this.noViewSpacePermission()) {
            return "error";
        }
        return "success";
    }

    public void setXhtmlContent(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public void setTemplateManager(PageTemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }

    @HtmlSafe
    public String renderXhtmlMacroTemplate(String xhtmlMacroStorageTemplate) throws XhtmlException, XMLStreamException {
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)new PageContext(this.getSpaceKey()));
        Map<String, Object> context = VelocityContextBuilder.contextBuilder(this.getContext()).build();
        String templateContent = this.getTemplateRenderedContent(xhtmlMacroStorageTemplate, context);
        return this.xhtmlContent.convertStorageToView(templateContent, (ConversionContext)conversionContext);
    }

    private String getTemplateRenderedContent(String defaultTemplatePath, Map<String, Object> context) {
        String pageTemplateContent = this.getSpaceForumListTemplateContent();
        return StringUtils.isEmpty((String)pageTemplateContent) || EMPTY_TEMPLATE.equals(StringUtils.deleteWhitespace((String)pageTemplateContent)) ? this.velocityHelperService.getRenderedTemplate(defaultTemplatePath, context) : this.velocityHelperService.getRenderedContent(pageTemplateContent, context);
    }

    private String getSpaceForumListTemplateContent() {
        PageTemplate pageTemplate = this.templateManager.getPageTemplate(SPACE_COMMUNITY_FORUMS_SUMMARY, this.getSpace());
        if (pageTemplate == null) {
            pageTemplate = this.templateManager.getGlobalPageTemplate(SPACE_COMMUNITY_FORUMS_SUMMARY);
        }
        return pageTemplate == null ? null : pageTemplate.getContent();
    }

    private Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("action", (Object)this);
        context.put("remoteuser", this.getAuthenticatedUser());
        context.put("user", this.getAuthenticatedUser());
        return context;
    }
}

