import React from 'react'
import ReactDOM from 'react-dom';
import { ensureUserIsAuthenticated } from "adaptavist-components/lib/common/confluence";

ensureUserIsAuthenticated().then(() => {
    const shouldRenderAfterBodyLoads = document.getElementById(ROOT_ELEMENT_ID) === null;

    // @ts-ignore
    shouldRenderAfterBodyLoads ? AJS.$(render) : render()
})

export const ROOT_ELEMENT_ID = 'forums-get-started-root'

const render = () => {
    const Root = require('./Root').default;
    ReactDOM.render(<Root/>, document.getElementById(ROOT_ELEMENT_ID));
}

// Webpack hot module replacement (Updates UI without refreshing browser)
if (module.hot) {
    module.hot.accept('./Root', render)
}