AJS.toInit(function ($) {

    //Model for ForumPalette config section
    function ForumPalette(params) {
        this.getPage = function () {
            return (params === undefined || params.page === undefined) ? '' : params.page;
        };

        this.isStickyOnTop = function () {
            return (params === undefined || params.stickyOnTop === undefined) ? 'true' : params.stickyOnTop.toString();
        };

        this.getPageSize = function () {
            return (params === undefined || params.pageSize === undefined) ? '20' : params.pageSize.toString();
        };

        this.isRecurse = function () {
            return (params === undefined || params.recurse === undefined) ? '' : params.recurse.toString();
        };

        this.isShowExcerpt = function () {
            return (params === undefined || params.showExcerpt === undefined) ? 'true' : params.showExcerpt.toString();
        };

        this.getBackgroundColor = function () {
            return (params === undefined || params.backgroundColor === undefined) ? '#4a6785' : params.backgroundColor.toString();
        };

        this.getTextColor = function () {
            return (params === undefined || params.textColor === undefined) ? '#ffffff' : params.textColor.toString();
        };

        this.isOverrideBackgroundColor = function () {
            return (params === undefined || params.overrideBackgroundColor === undefined) ? '' : params.overrideBackgroundColor.toString();
        };

        this.isOverrideTextColor = function () {
            return (params === undefined || params.overrideTextColor === undefined) ? '' : params.overrideTextColor.toString();
        };

        this.getTemplatePageId = function () {
            return (params === undefined || params.templatePageId === undefined) ? '' : params.templatePageId;
        };

        this.getTemplatePageName = function () {
            return (params === undefined || params.templatePageName === undefined) ? '' : params.templatePageName;
        };
    }

    function getValues() {
        var values = {
            page: AJS.$('#root-page').val(),
            stickyOnTop: AJS.$('#sticky-on-top').is(':checked'),
            pageSize: AJS.$('#no-of-topics').val(),
            recurse: AJS.$('#sub-forum').is(':checked'),
            showExcerpt: AJS.$('#show-excerpt').is(':checked'),
            backgroundColor: AJS.$('#background-color').val(),
            textColor: AJS.$('#text-color').val(),
            overrideBackgroundColor: AJS.$('#override-background-color').is(':checked'),
            overrideTextColor: AJS.$('#override-text-color').is(':checked'),
            templatePageId: AJS.$('#template-page').val(),
            templatePageName: AJS.$('#template-page').get("0").previousSibling.firstChild.text.trim()
        };

        if (AJS.$('#override-background-color').is(':checked')) {
            values['backgroundColor'] = AJS.$('#background-color').minicolors('value');
        } else {
            values['backgroundColor'] = '#4a6785';
        }

        if (AJS.$('#override-text-color').is(':checked')) {
            values['textColor'] = AJS.$('#text-color').minicolors('value');
        } else {
            values['textColor'] = '#ffffff';
        }
        return values;
    }

    function setupEvents() {
        //Setups Tabs in AJS
        AJS.tabs.setup();

        //Hooks up the Cancel Button
        AJS.$('#cancelButtonGroup').click(function (e) {
            e.preventDefault();
            AJS.dialog2('#forumpalette-dialog').remove();
        });

        //Hooks up the Insert Button
        AJS.$('#insertButtonGroup').click(function () {
            AJS.$('#forumPaletteForm').submit();
        });

        //Facilitates autocomplete
        AJS.Confluence.Binder.autocompletePage();

        AJS.$('#root-page').on('change', function (e, state) {
            AJS.$('#root-page-error').html('');
        });

        AJS.$('#no-of-topics').on('change', function (e, state) {
            AJS.$('#no-of-topics-error').html('');
        });

        AJS.$('#template-page').on('change', function (e, state) {
            AJS.$('#template-page-error').html('');
        });
    }

    function createRestForumMacro(macro) {
        //Creates a new ForumPalette object that holds the parameters, or initial empty values
        var forumPalette = new ForumPalette(macro.params);

        //Calls the dialog with Edit or Insert accordingly.
        AJS.dialog2(Forums.Macros.RestForum.dialog({
            title: macro.body === undefined ?
                AJS.I18n.getText('com.adaptavist.confluence.forums.rest-forum.new') :
                AJS.I18n.getText('com.adaptavist.confluence.forums.rest-forum.edit'),
            page: forumPalette.getPage(),
            stickyOnTop: forumPalette.isStickyOnTop(),
            pageSize: forumPalette.getPageSize(),
            recurse: forumPalette.isRecurse(),
            showExcerpt: forumPalette.isShowExcerpt(),
            backgroundColor: forumPalette.getBackgroundColor(),
            textColor: forumPalette.getTextColor(),
            overrideBackgroundColor: forumPalette.isOverrideBackgroundColor(),
            overrideTextColor: forumPalette.isOverrideTextColor(),
            templatePageName: forumPalette.getTemplatePageName(),
            templatePageId: forumPalette.getTemplatePageId()
        })).show();

        AJS.$('#background-color').minicolors();
        AJS.$('#text-color').minicolors();
        // focus on one element of the dialog because the select2 element for topic template loses the focus when selected as first element
        AJS.$('#root-page').focus();

        AJS.$('#link-details').on('click', function (event) {
            event.preventDefault();
            AJS.$('#tabs-details').show();
            AJS.$('#tabs-color').hide();
            AJS.$('#root-page').focus();
        });

        AJS.$('#link-color').on('click', function (event) {
            event.preventDefault();
            AJS.$('#tabs-details').hide();
            AJS.$('#tabs-color').show();
        });

        AJS.$('#insertButtonGroup').on('click', function (event) {
            AJS.$('#hiddenButton').click();
        });

        AJS.$(".aui-icon.aui-icon-small.aui-iconfont-info").tooltip({gravity: 'nw'});

        AJS.$('#forumPaletteForm').on('submit', function (e) {
            e.preventDefault();

            if (checkValidity()) {
                var t = tinymce.confluence.macrobrowser;

                AJS.Rte.BookmarkManager.restoreBookmark();

                if (t.editedMacroDiv) {
                    delete t.editedMacroDiv;
                }

                //can not pass undefined body
                if (macro.body === undefined) {
                    macro.body = "";
                }

                //Saves the Macro. Since the values is an array, it needs to convert it to JSON and then parse it back to display.
                tinymce.confluence.macrobrowser.macroBrowserComplete({
                    name: "rest-forum",
                    "bodyHtml": macro.body,
                    "params": getValues()
                });

                AJS.dialog2('#forumpalette-dialog').remove();
            }
        });
        setupEvents();
        createSelect2ForTemplatePage();
    }

    function checkValidity() {
        var isValid = true;
        var rootPageError = AJS.$('#root-page-error');
        rootPageError.val('');
        var noOfTopicsError = AJS.$('#no-of-topics-error');
        noOfTopicsError.val('');
        var rootPage = AJS.$('#root-page');
        var noOfTopics = AJS.$('#no-of-topics');
        var rootPageVal = rootPage.val();
        var noOfTopicsVal = noOfTopics.val();

        if (!noOfTopicsVal.match('^[1-9][0-9]?$')) {
            noOfTopicsError.text(AJS.I18n.getText('com.adaptavist.confluence.restforum.macro.number.of.topics'));
            isValid = false;
        }

        if (rootPageVal !== '') {
            var spaceKey = rootPageVal.substring(0, rootPageVal.indexOf(":"));
            var title = rootPageVal.substring(rootPageVal.indexOf(":") + 1, rootPageVal.length);

            var pageExists = checkPageExists(title, spaceKey);

            if (!pageExists) {
                rootPageError.text(AJS.I18n.getText('com.adaptavist.confluence.restforum.macro.rootpage.not.found'));
                isValid = false;
            }
        }
        return isValid;
    }

    function checkPageExists(title, spaceKey) {
        var exists;

        $.ajax({
            type: 'GET',
            async: false,
            url: Confluence.getContextPath() + "/rest/api/content",
            dataType: 'json',
            data: {
                spaceKey: spaceKey,
                title: title,
                type: "page"
            },
            statusCode: {
                404: function () {
                    exists = false;
                },
                200: function () {
                    exists = true;
                }
            }
        });
        return exists;
    }

    //Intercepts normal Macro config and replaces with this one
    AJS.MacroBrowser.setMacroJsOverride('rest-forum', {opener: createRestForumMacro});
});





