import React from 'react';
import ReactDOM from 'react-dom';
import 'whatwg-fetch'  // Importing this sets up a polyfill for the 'fetch' API. IE11 doesn't support fetch.

import App from './App'
import AnalyticsApiClient from "./ApiClient";

const AJS: any = (window as any).AJS;  // Keeps typescript happy

// Create an instance of the class responsible for fetching and pushing state
let apiClient = new AnalyticsApiClient({
    servletPath: AJS.contextPath()
});

// Starting point of configuration section
AJS.$(() => {
    ReactDOM.render(
        <App apiClient={apiClient} />,
        document.getElementById('forums-config-root')
    );
})
