import React from 'react'
import { ToggleAnalytics } from 'adaptavist-components/lib/analytics'
import styled from 'styled-components'

const EULA_URL = "https://www.adaptavist.com/company/adaptavist-eula/";
const PRIVACY_POLICY_URL = "https://www.adaptavist.com/company/privacy-policy";

// This section is the container with some applied css
const App = (props) => {

    return <div className="app-config-container">
        <h2>Anonymous Analytics</h2>
        <p>
            Analytics collects anonymous usage statistics about Community Forums for Confluence to help us improve your
            user experience. We do not share any information identifying you or your company.
        </p>
        <p>
            Please see our <a href={`${EULA_URL}`}>EULA</a> and <a href={`${PRIVACY_POLICY_URL}`}>Privacy Policy</a> for details.
        </p>
        <p>
            <i>Analytics is enabled by default.</i>
        </p>

        <ToggleAnalytics apiClient={props.apiClient}/>
    </div>
};

export default App

const Container = styled('section')`
  padding: 1rem 0;
  margin-bottom: 1rem
`

const Indent = styled('div')`
  padding: 0 2em;
`
