/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.params;

import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParamsParser {
    private static final String PAGE_AND_SPACE = "[^:]+:[^:]+";
    private final PageManager pageManager;
    private final SpaceManager spaceManager;

    @Autowired
    public ParamsParser(PageManager pageManager, SpaceManager spaceManager) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
    }

    public PageSpaceParam parsePageSpaceFrom(String pageParam, ConversionContext context) {
        if (StringUtils.isBlank((String)pageParam)) {
            return PageSpaceParam.emptyParams();
        }
        if (pageParam.matches(PAGE_AND_SPACE)) {
            return this.parsePageAndSpaceKey(pageParam);
        }
        Page page = this.getPage(pageParam, context.getSpaceKey());
        return page != null ? PageSpaceParam.pageSpaceKeyParam(page, context.getSpaceKey()) : PageSpaceParam.emptyParams();
    }

    public PageSpaceParam parsePageSpaceFrom(ConversionContext context) {
        ContentEntityObject entity = context.getEntity();
        if (entity instanceof Page) {
            return PageSpaceParam.pageSpaceKeyParam((Page)entity, context.getSpaceKey());
        }
        return PageSpaceParam.emptyParams();
    }

    public PageSpaceParam parsePageSpaceFrom(Page contextPage, String pageParam) {
        if (StringUtils.isBlank((String)pageParam)) {
            return PageSpaceParam.pageSpaceKeyParam(contextPage, contextPage.getSpaceKey());
        }
        if (pageParam.matches(PAGE_AND_SPACE)) {
            return this.parsePageAndSpaceKey(pageParam);
        }
        Page page = this.getPage(pageParam, contextPage.getSpaceKey());
        return page != null ? PageSpaceParam.pageSpaceKeyParam(page, contextPage.getSpaceKey()) : PageSpaceParam.emptyParams();
    }

    public PageSpaceParam parseSpaceFrom(String spaceKey) {
        if (StringUtils.isBlank((String)spaceKey)) {
            return PageSpaceParam.emptyParams();
        }
        return PageSpaceParam.spaceParam(spaceKey, this.spaceManager.getSpace(spaceKey));
    }

    public Set<PageSpaceParam> parseSpacesFrom(String spaceKeys) {
        if (StringUtils.isBlank((String)spaceKeys)) {
            return Collections.emptySet();
        }
        Sets.SetView spaceKeysSet = Sets.difference((Set)Sets.newHashSet((Object[])spaceKeys.split("\\s*[,;]\\s*")), (Set)Sets.newHashSet((Object[])new String[]{""}));
        HashSet<PageSpaceParam> spacesParams = new HashSet<PageSpaceParam>();
        for (String spaceKey : spaceKeysSet) {
            spacesParams.add(PageSpaceParam.spaceParam(spaceKey, this.spaceManager.getSpace(spaceKey)));
        }
        return spacesParams;
    }

    public PageSpaceParam parseSpaceFrom(ConversionContext context) {
        String spaceKey = context.getSpaceKey();
        return StringUtils.isNotBlank((String)spaceKey) ? PageSpaceParam.spaceParam(this.spaceManager.getSpace(spaceKey)) : PageSpaceParam.emptyParams();
    }

    private Page getPage(String pageTitle, String spaceKey) {
        return this.pageManager.getPage(spaceKey, pageTitle);
    }

    private PageSpaceParam parsePageAndSpaceKey(String pageAndSpace) {
        String[] pageAndSpaceKey = pageAndSpace.split("\\s*[:]\\s*");
        String spaceKey = pageAndSpaceKey[0];
        String pageTitle = pageAndSpaceKey[1];
        return PageSpaceParam.pageSpaceKeyParam(this.getPage(pageTitle, spaceKey), spaceKey);
    }
}

