/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.column;

import com.adaptavist.confluence.forums.model.datatypes.DataItemType;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeFormatter;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.view.macros.AbstractForumMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import java.util.Map;

public abstract class AbstractColumnMacro
extends AbstractForumMacro {
    public static final String REST_FORUM_COLUMN_MACRO_TEMPLATE = "forum/templates/vm/rest-forum-column-macro.vm";
    public static final String PARAM_DATATYPE = "datatype";
    public static final String PARAM_HEADING = "heading";
    public static final String PARAM_FORMAT = "format";
    private DataTypeManager dataTypeManager;
    private DataItemType dataItemType;
    private String defaultFormat;
    private String defaultHeading;

    public AbstractColumnMacro(LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator, DataTypeManager dataTypeManager) {
        super(licensingSupport, macroServiceAggregator);
        this.dataTypeManager = dataTypeManager;
    }

    @Override
    public String executeInternal(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        DataItemType dataItemType = this.getDataItemType();
        String format = this.getFormatParam(parameters);
        String heading = this.getHeadingParam(parameters);
        DataTypeFormatter formatter = this.dataTypeManager.getDataTypeFormatter(dataItemType.getFormatterName());
        if (formatter == null || !formatter.hasPredefinedFormat(format)) {
            throw new MacroExecutionException(this.getText("com.adaptavist.confluence.restforum.columnmacro.invalid.formatter", format, this.getDataItemName()));
        }
        if (formatter.getResourceKey() != null) {
            this.getWebResourceManager().requireResource(formatter.getResourceKey());
        }
        VelocityContextBuilder contextBuilder = VelocityContextBuilder.contextBuilder().put(PARAM_DATATYPE, this.getDataItemName()).put(PARAM_FORMAT, formatter.getFormatFor(format)).put(PARAM_HEADING, heading);
        this.addMoreParamsToContext(parameters, contextBuilder);
        return this.resolveTemplate(this.getRenderedTemplateLocation()).withContext(contextBuilder);
    }

    protected void addMoreParamsToContext(Map<String, String> parameters, VelocityContextBuilder contextBuilder) {
    }

    protected abstract String getDataItemName();

    @Override
    protected String getRenderedTemplateLocation() {
        return REST_FORUM_COLUMN_MACRO_TEMPLATE;
    }

    protected String getDefaultFormat() {
        if (this.defaultFormat == null) {
            String defaultFormatterName = this.getDataItemType().getFormatterName();
            this.defaultFormat = this.dataTypeManager.getDataTypeFormatter(defaultFormatterName).getDefaultFormatId();
        }
        return this.defaultFormat;
    }

    protected String getDefaultHeading() {
        return this.getText(this.getDataItemType().getDefaultHeading(), new String[0]);
    }

    protected String getFormatParam(Map<String, String> parameters) {
        if (this.hasParam(PARAM_FORMAT, parameters)) {
            return this.getParam(PARAM_FORMAT, parameters);
        }
        return this.getDefaultFormat();
    }

    protected String getHeadingParam(Map<String, String> parameters) {
        if (this.hasParam(PARAM_HEADING, parameters)) {
            return this.getParam(PARAM_HEADING, parameters);
        }
        return this.getDefaultHeading();
    }

    protected DataItemType getDataItemType() {
        if (this.dataItemType == null) {
            this.dataItemType = this.dataTypeManager.getDataItemType(this.getDataItemName());
        }
        return this.dataItemType;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

