/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros;

import com.adaptavist.confluence.forums.view.macros.AbstractForumMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSummaryMacro
extends AbstractForumMacro {
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_SPACE = "space";
    public static final String MODE_PAGE = "page";
    public static final String MODE_SPACE = "space";
    public static final String PARAM_SHOW_PICS = "showPics";
    public static final String PARAM_SHOW_AUTHOR = "showAuthor";
    public static final String PARAM_SHOW_EXCERPT = "showExcerpt";
    public static final String PARAM_HEADING = "tableHeading";
    public static final String PARAM_ROOT_PAGE_ID = "rootPageId";
    public static final String PARAM_SPACE_KEY = "spaceKey";
    public static final String PARAM_RECURSE = "recurse";
    public static final String PARAM_SORT_BY = "sortBy";
    public static final String REST_FORUM = "rest-forum";
    public static final String DEFAULT_BACKGROUND_COLOR = "#4a6785";
    public static final String DEFAULT_TEXT_COLOR = "#ffffff";
    private XhtmlContent xhtmlContent;

    public AbstractSummaryMacro(LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator, XhtmlContent xhtmlContent) {
        super(licensingSupport, macroServiceAggregator);
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public String executeInternal(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException, XhtmlException {
        final String[] backgroundAndTextColor = new String[]{DEFAULT_BACKGROUND_COLOR, DEFAULT_TEXT_COLOR};
        if (context.getPageContext().getEntity() != null) {
            this.xhtmlContent.handleMacroDefinitions(context.getPageContext().getEntity().getBodyAsString(), context, new MacroDefinitionHandler(){

                public void handle(MacroDefinition macroDefinition) {
                    if (macroDefinition.getName().equals(AbstractSummaryMacro.REST_FORUM) && macroDefinition.getParameter("backgroundColor") != null) {
                        backgroundAndTextColor[0] = macroDefinition.getParameter("backgroundColor");
                        backgroundAndTextColor[1] = macroDefinition.getParameter("textColor");
                    }
                }
            });
        }
        String mode = this.getParam(PARAM_MODE, parameters, this.getDefaultMode());
        String pageParam = this.getParam("page", parameters, "");
        String spaceKeyParam = this.getParam("space", parameters, StringUtils.defaultIfBlank((String)context.getSpaceKey(), (String)""));
        boolean showExcerpt = this.getBooleanParam(PARAM_SHOW_EXCERPT, parameters, true);
        boolean showPics = this.getBooleanParam(PARAM_SHOW_PICS, parameters, true);
        if ("page".equalsIgnoreCase(mode)) {
            PageSpaceParam pageSpaceParam = this.getPageParam(pageParam, context);
            if (!pageSpaceParam.hasPage()) {
                return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.macro.no.such.page", pageParam);
            }
            pageParam = pageSpaceParam.getPageIdAsString();
        } else if ("space".equalsIgnoreCase(mode)) {
            Set<PageSpaceParam> spaceParams = this.getSpaceParams(spaceKeyParam, context);
            if (spaceParams.isEmpty()) {
                return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.resource.space.or.page.required", new String[0]);
            }
            for (PageSpaceParam spaceParam : spaceParams) {
                if (spaceParam.hasSpace()) continue;
                return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.resource.invalid.space.key", spaceParam.getSpaceKey());
            }
        }
        VelocityContextBuilder contextBuilder = VelocityContextBuilder.contextBuilder().put(PARAM_ROOT_PAGE_ID, pageParam).put(PARAM_SPACE_KEY, spaceKeyParam).put(PARAM_SHOW_PICS, showPics).put(PARAM_SHOW_EXCERPT, showExcerpt).put("backgroundColor", backgroundAndTextColor[0]).put("textColor", backgroundAndTextColor[1]);
        this.addSpecificParams(parameters, contextBuilder);
        return this.resolveTemplate(this.getRenderedTemplateLocation()).withContext(contextBuilder);
    }

    private PageSpaceParam getPageParam(String pageParam, ConversionContext context) {
        return StringUtils.isNotBlank((String)pageParam) ? this.getParamsParser().parsePageSpaceFrom(pageParam, context) : this.getParamsParser().parsePageSpaceFrom(context);
    }

    private Set<PageSpaceParam> getSpaceParams(String spaceParam, ConversionContext context) {
        return StringUtils.isNotBlank((String)spaceParam) ? this.getParamsParser().parseSpacesFrom(spaceParam) : Collections.singleton(this.getParamsParser().parseSpaceFrom(context));
    }

    protected abstract void addSpecificParams(Map<String, String> var1, VelocityContextBuilder var2);

    protected abstract String getDefaultMode();

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

