/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.impl.AbstractSpaceKeyValidator;
import com.atlassian.confluence.spaces.SpaceManager;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceKeyCriteriaValidator
extends AbstractSpaceKeyValidator {
    @Autowired
    public SpaceKeyCriteriaValidator(SpaceManager spaceManager) {
        super(spaceManager);
    }

    @Override
    protected ValidationReport validateSpaceKeys(Set<String> spaceKeys) {
        ValidationReport report = ValidationReport.success();
        for (String spaceKey : spaceKeys) {
            if (!StringUtils.isNotBlank((String)spaceKey) || this.getSpace(spaceKey) != null) continue;
            report = ValidationReport.combineAll(report, ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.space.key", new Serializable[]{spaceKey}), new ValidationReport[0]);
        }
        return report;
    }
}

