/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.impl.PermissionsSupport;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PagePermissionValidator
implements Validator<String> {
    private final PermissionsSupport permissionsSupport;
    private final PageManager pageManager;

    @Autowired
    public PagePermissionValidator(PermissionsSupport permissionsSupport, PageManager pageManager) {
        this.permissionsSupport = permissionsSupport;
        this.pageManager = pageManager;
    }

    @Override
    public ValidationReport validate(String pageId) {
        Long pageIdAsLong = Long.valueOf(pageId);
        Page page = this.pageManager.getPage(pageIdAsLong.longValue());
        if (!this.permissionsSupport.hasViewPagePermission((User)AuthenticatedUserThreadLocal.get(), (AbstractPage)page)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.macro.no.permission", new Serializable[0]);
        }
        return ValidationReport.success();
    }
}

