/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;

public class ValidationFlow {
    private final boolean continueOnFailure;
    private final StartValidationStep startValidationStep = new StartValidationStep();
    private final RepeatValidationStep repeatValidationStep = new RepeatValidationStep();
    private ValidationReport validationReport = ValidationReport.success();

    private ValidationFlow(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public static StartValidationStep validationFlow() {
        return ValidationFlow.validationFlow(false);
    }

    public static StartValidationStep validationFlow(boolean continueOnValidationFailure) {
        return new ValidationFlow(continueOnValidationFailure).getStartValidationStep();
    }

    public StartValidationStep getStartValidationStep() {
        return this.startValidationStep;
    }

    public RepeatValidationStep getRepeatValidationStep() {
        return this.repeatValidationStep;
    }

    public ValidationReport getValidationReport() {
        return this.validationReport;
    }

    private boolean isNextStepAvailable() {
        return this.continueOnFailure || this.validationReport.isSuccess();
    }

    private ValidationFlow updateValidationReport(ValidationReport validationReport) {
        this.validationReport = this.validationReport.combinedWith(validationReport);
        return this;
    }

    public class ValidatorInvoker<T> {
        private final T toValidate;

        public ValidatorInvoker(T toValidate) {
            this.toValidate = toValidate;
        }

        public RepeatValidationStep with(Validator<T> validator) {
            if (ValidationFlow.this.isNextStepAvailable()) {
                ValidationFlow.this.updateValidationReport(validator.validate(this.toValidate));
            }
            return ValidationFlow.this.getRepeatValidationStep();
        }
    }

    public class RepeatValidationStep {
        public <T> ValidatorInvoker<T> andThen(T toValidate) {
            return new ValidatorInvoker<T>(toValidate);
        }

        public ValidationReport andReport() {
            return ValidationFlow.this.getValidationReport();
        }
    }

    public class StartValidationStep {
        public <T> ValidatorInvoker<T> validate(T toValidate) {
            return new ValidatorInvoker<T>(toValidate);
        }
    }
}

