/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.query;

import com.adaptavist.confluence.forums.service.search.query.AbstractForumsQuery;
import com.adaptavist.confluence.forums.service.search.query.ForumStringRangeQuery;
import com.adaptavist.confluence.forums.service.search.query.range.ForumStringRange;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.List;

public class CreationDateForumQuery
extends ForumStringRangeQuery<AbstractForumsQuery, Long> {
    private static final String KEY = "creation-date-filter-key";

    public CreationDateForumQuery(ForumStringRange range) {
        super(KEY, range);
    }

    public static CreationDateForumQuery getInstance(List<String> filterValues, FilterValueType valueType) {
        ForumStringRange range = CreationDateForumQuery.filterRange(filterValues, valueType);
        if (!range.isEmpty()) {
            return new CreationDateForumQuery(range);
        }
        return null;
    }

    @Override
    protected String getIndexField() {
        return "forumIndexPageCreationDate";
    }

    @Override
    protected Long processRangeStart(String start) {
        return this.getDateToMillis(start);
    }

    @Override
    protected Long processRangeEnd(String end) {
        return this.getNextDayDateToMillis(end);
    }

    @Override
    protected SearchQuery buildRangeQuery(Long start, Long end) {
        return this.longRangeQuery(start, end);
    }
}

