/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.service.search.criteria.SearchCriteriaConverter;
import com.adaptavist.confluence.forums.service.search.sort.fields.PageTitleForumSort;
import com.adaptavist.confluence.forums.view.beans.search.Pagination;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentPermissionsQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.user.User;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSearchCriteriaConverter<T extends SearchCriteria>
implements SearchCriteriaConverter<T> {
    private static final int CONFLUENCE_7_20_MINIMUM_BUILD_NUMBER = 18270;
    private static final String CONF_PAGE_FORMAT = "com.atlassian.confluence.pages.Page-%s";
    private static final Set<String> EMPTY_VALUES = Sets.newHashSet((Object[])new String[]{"", null});
    private static final SearchQuery TOPIC_CONTENT = new ContentTypeQuery(Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG));
    private static final SearchQuery FORUM_CONTENT = new ContentTypeQuery(ContentTypeEnum.PAGE);
    private static final SearchQuery TOPIC_FLAG = new TextFieldQuery("forumIndexPageIsTopicInt", "1", BooleanOperator.AND);
    private static final SearchQuery FORUM_FLAG = new TextFieldQuery("forumIndexPageIsForumInt", "1", BooleanOperator.AND);
    private static final SearchQuery[] TOPIC_QUERIES = new SearchQuery[]{TOPIC_FLAG, TOPIC_CONTENT};
    private static final SearchQuery[] FORUM_QUERIES = new SearchQuery[]{FORUM_FLAG, FORUM_CONTENT};
    private final ApplicationProperties applicationProperties;
    private final UserAccessor userAccessor;

    public AbstractSearchCriteriaConverter(ApplicationProperties applicationProperties, UserAccessor userAccessor) {
        this.applicationProperties = applicationProperties;
        this.userAccessor = userAccessor;
    }

    @Override
    public ContentSearch convertToContentSearch(T searchCriteria) {
        ArrayList<SearchQuery> mustQueries = new ArrayList<SearchQuery>();
        ArrayList<SearchQuery> mustNotQueries = new ArrayList<SearchQuery>();
        this.mustQueries(mustQueries, searchCriteria);
        this.mustNotQueries(mustNotQueries, searchCriteria);
        this.filterQueries(mustQueries, searchCriteria);
        SearchSort searchSort = this.getSearchSort(searchCriteria);
        try {
            switch (this.isConfluence720OrAbove()) {
                case -1: {
                    BooleanQuery searchQuery = new BooleanQuery(mustQueries, null, mustNotQueries);
                    return this.compatibilityContentSearch((SearchQuery)searchQuery, searchSort, this.compatibilityPermissionsFilter(), (Pagination)searchCriteria, searchSort instanceof PageTitleForumSort);
                }
            }
            SearchQuery contentPermission = this.permissionsFilter();
            BooleanQuery.Builder queryBuilder = BooleanQuery.builder();
            queryBuilder.addFilter(contentPermission);
            queryBuilder.addMust(mustQueries);
            queryBuilder.addMustNot(mustNotQueries);
            return this.initialiseContentSearch(queryBuilder.build(), searchSort, (Pagination)searchCriteria, searchSort instanceof PageTitleForumSort);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected abstract void mustQueries(List<SearchQuery> var1, T var2);

    protected abstract void mustNotQueries(List<SearchQuery> var1, T var2);

    protected abstract void filterQueries(List<SearchQuery> var1, T var2);

    protected abstract SearchSort getSearchSort(T var1);

    protected SearchQuery[] topicQueries() {
        return TOPIC_QUERIES;
    }

    protected SearchQuery[] forumQueries() {
        return FORUM_QUERIES;
    }

    protected SearchQuery recursiveQuery(String rootPageId, boolean recursive) {
        return this.fieldQuery(recursive ? "forumIndexPageAncestorIds" : "forumIndexPageParentId", rootPageId);
    }

    protected SearchQuery skipConfluencePagesQuery(String parentPageId) {
        if (StringUtils.isBlank((String)parentPageId)) {
            return null;
        }
        return this.fieldQuery("handle", String.format(CONF_PAGE_FORMAT, parentPageId));
    }

    protected SearchQuery fieldQuery(String fieldName, String value) {
        if (StringUtils.isBlank((String)fieldName) || StringUtils.isBlank((String)value)) {
            return null;
        }
        return new TextFieldQuery(fieldName, value, BooleanOperator.AND);
    }

    protected SearchQuery inSpaceQuery(String spaceKey) {
        if (StringUtils.isBlank((String)spaceKey)) {
            return null;
        }
        Sets.SetView spaceKeys = Sets.difference((Set)Sets.newHashSet((Object[])spaceKey.trim().split("\\s*[,;]\\s*")), EMPTY_VALUES);
        return spaceKeys.isEmpty() ? null : new InSpaceQuery((Set)spaceKeys);
    }

    protected void addQuery(List<SearchQuery> searchQueries, SearchQuery ... queriesToAdd) {
        if (queriesToAdd == null || searchQueries == null) {
            return;
        }
        for (SearchQuery queryToAdd : queriesToAdd) {
            if (queryToAdd == null) continue;
            searchQueries.add(queryToAdd);
        }
    }

    protected SearchQuery permissionsFilter() {
        ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        return ContentPermissionsQuery.builder().user(remoteUser).groupNames(this.userAccessor.getGroupNames((User)remoteUser)).build();
    }

    protected Object compatibilityPermissionsFilter() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<ContentPermissionsSearchFilter> contentPermissionFilterClazz = ContentPermissionsSearchFilter.class;
        Method method = contentPermissionFilterClazz.getMethod("getInstance", new Class[0]);
        return method.invoke(null, new Object[0]);
    }

    private ContentSearch initialiseContentSearch(SearchQuery searchQuery, SearchSort searchSort, Pagination searchCriteria, boolean sortByTitle) throws Exception {
        Class[] contentSearchArgsType = new Class[]{SearchQuery.class, SearchSort.class, Integer.TYPE, Integer.TYPE};
        Constructor contentSearchConstructor = ContentSearch.class.getConstructor(contentSearchArgsType);
        Object[] contentSearchArgs = new Object[]{searchQuery, searchSort, sortByTitle ? 0 : searchCriteria.getStartIndex(), searchCriteria.getPageSize() <= 0 || sortByTitle ? Integer.MAX_VALUE : searchCriteria.getPageSize()};
        return (ContentSearch)contentSearchConstructor.newInstance(contentSearchArgs);
    }

    private ContentSearch compatibilityContentSearch(SearchQuery searchQuery, SearchSort searchSort, Object searchFilter, Pagination searchCriteria, boolean sortByTitle) throws Exception {
        Class<?> sfClazz = Class.forName("com.atlassian.confluence.search.v2.SearchFilter");
        Class[] contentSearchArgsType = new Class[]{SearchQuery.class, SearchSort.class, sfClazz, Integer.TYPE, Integer.TYPE};
        Constructor contentSearchConstructor = ContentSearch.class.getConstructor(contentSearchArgsType);
        Object[] contentSearchArgs = new Object[]{searchQuery, searchSort, sfClazz.cast(searchFilter), sortByTitle ? 0 : searchCriteria.getStartIndex(), searchCriteria.getPageSize() <= 0 || sortByTitle ? Integer.MAX_VALUE : searchCriteria.getPageSize()};
        return (ContentSearch)contentSearchConstructor.newInstance(contentSearchArgs);
    }

    private Integer isConfluence720OrAbove() {
        return Integer.compare(Integer.parseInt(this.applicationProperties.getBuildNumber()), 18270);
    }
}

