/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.adaptavist.confluence.forums.service.StickyPageManager;
import com.adaptavist.confluence.forums.service.impl.PagePropertySupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultStickyPageManager
implements StickyPageManager {
    private final PermissionsConfigRepository permissionsConfigService;
    private final PagePropertySupport propertySupport;

    @Autowired
    public DefaultStickyPageManager(PagePropertySupport pagePropertySupport, PermissionsConfigRepository permissionsConfigService) {
        this.propertySupport = pagePropertySupport;
        this.permissionsConfigService = permissionsConfigService;
    }

    @Override
    public void markPageAsSticky(AbstractPage page) {
        this.propertySupport.addPageProperty(page, "com.adaptavist.forum.FORUM_STICKY_PAGE");
    }

    @Override
    public void removeStickyForPage(AbstractPage page) {
        this.propertySupport.removePageProperty(page, "com.adaptavist.forum.FORUM_STICKY_PAGE");
    }

    @Override
    public boolean isPageMarkedAsSticky(AbstractPage page) {
        return this.propertySupport.isPagePropertySet(page, "com.adaptavist.forum.FORUM_STICKY_PAGE");
    }

    @Override
    public boolean hasUpdateStickyPermission(User user, AbstractPage page) {
        PermissionsConfig.PermissionType permissionType = this.permissionsConfigService.getStickyPermissionsForSpace(this.propertySupport.getSpaceKey(page));
        return this.propertySupport.getPermissionsSupport().hasPermission(permissionType, user, page);
    }
}

