/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.service.StickyPageManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageStatusManager
implements PageStatusManager {
    private final ForumManager forumManager;
    private final StickyPageManager stickyPageManager;

    @Autowired
    public DefaultPageStatusManager(ForumManager forumManager, StickyPageManager stickyPageManager) {
        this.forumManager = forumManager;
        this.stickyPageManager = stickyPageManager;
    }

    @Override
    public void updateLockedStatus(AbstractPage page, boolean newStatus) {
        if (this.forumManager.isPageLocked(page) == newStatus) {
            return;
        }
        if (newStatus) {
            this.forumManager.lockPage(page);
        } else {
            this.forumManager.unlockPage(page);
        }
    }

    @Override
    public void updateStickyStatus(AbstractPage page, boolean newStatus) {
        if (this.stickyPageManager.isPageMarkedAsSticky(page) == newStatus) {
            return;
        }
        if (newStatus) {
            this.stickyPageManager.markPageAsSticky(page);
        } else {
            this.stickyPageManager.removeStickyForPage(page);
        }
    }

    @Override
    public boolean getLockedStatus(AbstractPage page) {
        return this.forumManager.isPageLocked(page);
    }

    @Override
    public boolean getStickyStatus(AbstractPage page) {
        return this.stickyPageManager.isPageMarkedAsSticky(page);
    }

    @Override
    public PageStatusManager.PageStatus getPageStatus(AbstractPage page) {
        boolean isPage = page instanceof Page;
        boolean forum = isPage && this.forumManager.isForum((Page)page);
        boolean subForum = isPage && this.forumManager.isSubForum((Page)page);
        boolean topic = this.forumManager.isTopic(page);
        boolean locked = this.forumManager.isPageLocked(page);
        boolean sticky = this.stickyPageManager.isPageMarkedAsSticky(page);
        return new PageStatusManager.PageStatus(forum, subForum, topic, locked, sticky);
    }

    @Override
    public boolean areAllPagesForums(List<AbstractPage> pages) {
        for (AbstractPage page : pages) {
            PageStatusManager.PageStatus pageStatus = this.getPageStatus(page);
            if (pageStatus.isForum()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeAllForumProperties(Page forumPage) {
        if (forumPage != null) {
            for (Page descendant : forumPage.getDescendents()) {
                if (!this.forumManager.isTopic((AbstractPage)descendant)) continue;
                this.stickyPageManager.removeStickyForPage((AbstractPage)descendant);
                this.forumManager.unlockPage((AbstractPage)descendant);
            }
            this.forumManager.removeForum(forumPage);
        }
    }
}

