/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.dao.ao.builder.ActivityScoreConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.repository.ActivityScoreConfigRepository;
import com.adaptavist.confluence.forums.model.ActivityScore;
import com.adaptavist.confluence.forums.service.ActivityScoreCalculator;
import com.adaptavist.confluence.forums.service.ActivityScoreManager;
import com.adaptavist.confluence.forums.service.search.ForumSearchManager;
import com.adaptavist.confluence.forums.service.search.exception.InvalidSearchQueryException;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultActivityScoreManager
implements ActivityScoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultActivityScoreManager.class);
    private final ActivityScoreCalculator activityScoreCalculator;
    private final ActivityScoreConfigRepository activityScoreService;
    private final ConfluenceIndexer indexer;
    private final ForumSearchManager forumSearchManager;
    private final PageManager pageManager;

    @Autowired
    public DefaultActivityScoreManager(ActivityScoreCalculator activityScoreCalculator, ActivityScoreConfigRepository activityScoreService, ConfluenceIndexer indexer, ForumSearchManager forumSearchManager, PageManager pageManager) {
        this.activityScoreCalculator = activityScoreCalculator;
        this.activityScoreService = activityScoreService;
        this.indexer = indexer;
        this.forumSearchManager = forumSearchManager;
        this.pageManager = pageManager;
    }

    @Override
    public ActivityScore getActivityScore(Page page) {
        return this.activityScoreCalculator.calculateScore(page);
    }

    @Override
    public boolean hasGlobalActivityScoreConfig() {
        ActivityScoreConfig[] activityScoreConfigs = this.activityScoreService.getGlobalActivityScoreConfig();
        return activityScoreConfigs.length > 0;
    }

    @Override
    public void createGlobalActivityScoreConfig() {
        this.activityScoreService.saveGlobalActivityScoreConfig(ActivityScoreConfigBuilder.defaultGlobalActivityScoreBuilder());
    }

    @Override
    public void updateOutdatedActivityScores() {
        try {
            SearchQuery outdatedScoreQuery = this.outdatedActivityScoreQuery();
            for (SearchResultAccessor resultAccessor : this.forumSearchManager.search(outdatedScoreQuery)) {
                this.indexer.reIndex((Searchable)this.pageManager.getAbstractPage(resultAccessor.getId()));
            }
        }
        catch (InvalidSearchQueryException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private SearchQuery outdatedActivityScoreQuery() {
        TextFieldQuery topicQuery = new TextFieldQuery("forumIndexPageIsTopicInt", "1", BooleanOperator.AND);
        ContentTypeQuery pageOrBlog = new ContentTypeQuery(Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG));
        SearchQuery validScore = this.validScoreQuery();
        List<SearchQuery> mustQueries = this.querySet(new SearchQuery[]{topicQuery, validScore, pageOrBlog});
        return new BooleanQuery(mustQueries, null, null);
    }

    private SearchQuery validScoreQuery() {
        String range = String.format("[%s TO %s]", "0", DateTools.dateToString((Date)new Date(), (DateTools.Resolution)DateTools.Resolution.MINUTE));
        return new TextFieldQuery("forumIndexPageActivityScoreExpiry", range, BooleanOperator.AND);
    }

    private List<SearchQuery> querySet(SearchQuery ... searchQueries) {
        ArrayList<SearchQuery> queries = new ArrayList<SearchQuery>(searchQueries.length);
        Collections.addAll(queries, searchQueries);
        return queries;
    }
}

