/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.repository.ActivityScoreConfigRepository;
import com.adaptavist.confluence.forums.model.ActivityScore;
import com.adaptavist.confluence.forums.model.ActivityScoreDateMultiplier;
import com.adaptavist.confluence.forums.model.ContentAgeConfig;
import com.adaptavist.confluence.forums.service.ActivityScoreCalculator;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultActivityScoreCalculator
implements ActivityScoreCalculator {
    private final ActivityScoreConfigRepository activityScoreConfigService;

    @Autowired
    public DefaultActivityScoreCalculator(ActivityScoreConfigRepository activityScoreConfigService) {
        this.activityScoreConfigService = activityScoreConfigService;
    }

    @Override
    public ActivityScore calculateScore(Page page) {
        return this.calculateScoreFor(page);
    }

    private ActivityScore calculateScoreFor(Page page) {
        try {
            ActivityScoreConfig activityScoreConfig = this.getActivityScoreConfig(page);
            int editCount = page.getVersion();
            List comments = page.getComments();
            int commentCount = comments.size();
            Date lastUpdate = page.getLastModificationDate();
            Date mostRecentComment = this.getMostRecentComment(comments);
            Date mostRecentUpdate = this.mostRecentUpdate(mostRecentComment, lastUpdate);
            int attachmentCount = page.getAttachments().size();
            ActivityScoreConfig.ContentAge contentAge = activityScoreConfig.getContentAge();
            double dateMultiplier = this.getDateMultiplier(mostRecentUpdate, contentAge);
            long score = this.computeScore(dateMultiplier, commentCount, editCount, attachmentCount, activityScoreConfig);
            Long nextRecalculationDate = this.getNextRecalculationDate(mostRecentUpdate, contentAge);
            return new ActivityScore(score, nextRecalculationDate);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private long computeScore(double date, int comment, int edit, int attachment, ActivityScoreConfig scoreConfig) {
        if (date > 0.0) {
            int commentScore = comment * scoreConfig.getCommentMultiplier();
            int editScore = edit * scoreConfig.getEditMultiplier();
            int attachmentScore = attachment * scoreConfig.getAttachmentMultiplier();
            return new Double(date * (double)(commentScore + editScore + attachmentScore)).longValue();
        }
        return 0L;
    }

    protected double getDateMultiplier(Date mostRecentUpdate, ActivityScoreConfig.ContentAge contentAge) {
        long millisAgo = new Date().getTime() - mostRecentUpdate.getTime();
        List<ActivityScoreDateMultiplier> dateMultipliers = ContentAgeConfig.getDateMultipliers(contentAge);
        for (ActivityScoreDateMultiplier dateMultiplier : dateMultipliers) {
            if (dateMultiplier.getDateValueAsMillis() <= millisAgo) continue;
            return dateMultiplier.getMultiplier();
        }
        return 0.0;
    }

    protected Long getNextRecalculationDate(Date lastUpdateDate, ActivityScoreConfig.ContentAge contentAge) {
        long millisAgo = new Date().getTime() - lastUpdateDate.getTime();
        List<ActivityScoreDateMultiplier> dateMultipliers = ContentAgeConfig.getDateMultipliers(contentAge);
        for (ActivityScoreDateMultiplier dateMultiplier : dateMultipliers) {
            if (dateMultiplier.getDateValueAsMillis() <= millisAgo) continue;
            return lastUpdateDate.getTime() + dateMultiplier.getDateValueAsMillis();
        }
        return null;
    }

    private Date getMostRecentComment(List<Comment> comments) {
        Date mostRecentComment = new Date(0L);
        for (Comment comment : comments) {
            if (!comment.getCreationDate().after(mostRecentComment)) continue;
            mostRecentComment = comment.getCreationDate();
        }
        return mostRecentComment;
    }

    private Date mostRecentUpdate(Date lastComment, Date lastUpdate) {
        return lastComment.after(lastUpdate) ? lastComment : lastUpdate;
    }

    private ActivityScoreConfig getActivityScoreConfig(Page page) {
        return this.activityScoreConfigService.getSpaceActivityScoreConfig(page.getSpaceKey());
    }
}

