/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.pluginevent;

import com.adaptavist.analytic.metadata.PluginMetadataProvider;
import com.adaptavist.confluence.forums.service.analytic.event.UserAnalyticMetrics;
import com.adaptavist.confluence.forums.service.analytic.pluginevent.PluginEventMetrics;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.sal.api.license.LicenseHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class PluginEventMetricsImpl
implements PluginEventMetrics {
    private static final String PLUGIN_KEY = "com.adaptavist.confluence.forums";
    private static final String ACTION = "Action";
    private static final String USER_KEY = "user-key";
    private static final String APP_NAME = "app-name";
    private static final String BASE_URL = "base-url";
    private static final String APP_VERSION = "app-version";
    private static final String CONFLUENCE_VERSION = "confluence-version";
    private static final String EVENT_DATE = "event-date";
    private static final String SERVER_ID = "userID";
    private static final String GROUP_ID = "groupID";
    private static final String TRIGGERED_BY = "triggeredBy";
    private final PluginMetadataProvider pluginMetadataProvider;
    private final SettingsManager settingsManager;
    private final LicenseHandler licenseHandler;
    private final UserAnalyticMetrics userAnalyticMetrics;

    public PluginEventMetricsImpl(PluginMetadataProvider pluginMetadataProvider, SettingsManager settingsManager, LicenseHandler licenseHandler, UserAnalyticMetrics userAnalyticMetrics) {
        this.pluginMetadataProvider = pluginMetadataProvider;
        this.settingsManager = settingsManager;
        this.licenseHandler = licenseHandler;
        this.userAnalyticMetrics = userAnalyticMetrics;
    }

    @Override
    public String getSen() {
        return this.pluginMetadataProvider.get().getSupportEntitlementNumber();
    }

    @Override
    public Map<String, String> getMetricsMap(String eventType) {
        HashMap<String, String> analyticAttributes = new HashMap<String, String>();
        analyticAttributes.put(ACTION, eventType);
        analyticAttributes.put(USER_KEY, this.pluginMetadataProvider.get().getSupportEntitlementNumber());
        analyticAttributes.put(APP_NAME, PLUGIN_KEY);
        analyticAttributes.put(BASE_URL, this.settingsManager.getGlobalSettings().getBaseUrl());
        analyticAttributes.put(APP_VERSION, this.pluginMetadataProvider.get().getVersion());
        analyticAttributes.put(CONFLUENCE_VERSION, this.pluginMetadataProvider.get().getPlatformVersion());
        analyticAttributes.put(EVENT_DATE, new Date().toString());
        analyticAttributes.put(SERVER_ID, this.licenseHandler.getServerId());
        analyticAttributes.put(GROUP_ID, this.licenseHandler.getServerId());
        analyticAttributes.put(TRIGGERED_BY, this.userAnalyticMetrics.getUserHashCode());
        return analyticAttributes;
    }
}

