/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.module.impl;

import com.adaptavist.confluence.forums.model.module.AbstractForumModuleDescriptor;
import com.adaptavist.confluence.forums.service.search.sort.impl.DefaultForumSearchSortManager;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class SearchSorterModuleDescriptor
extends AbstractForumModuleDescriptor {
    private static final String SORTER = "sorter";
    private static final String ASC_INSTANCE_KEY = "ascending";
    private static final String DESC_INSTANCE_KEY = "descending";
    private Set<String> sorterKeys;

    public SearchSorterModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        this.assertKeyPresent(element);
        this.assertChildElementPresent(element, SORTER);
        this.sorterKeys = new HashSet<String>();
        boolean ascInstance = this.getBooleanAttribute(element, ASC_INSTANCE_KEY, false);
        boolean descInstance = this.getBooleanAttribute(element, DESC_INSTANCE_KEY, false);
        for (Element sorter : this.getChildElements(element, SORTER)) {
            this.assertKeyPresent(sorter);
            this.defineKeys(sorter, ascInstance, descInstance);
        }
    }

    private void defineKeys(Element sorter, boolean ascending, boolean descending) {
        String key = this.getElementKey(sorter);
        boolean ascInstance = this.getBooleanAttribute(sorter, ASC_INSTANCE_KEY, ascending);
        boolean descInstance = this.getBooleanAttribute(sorter, DESC_INSTANCE_KEY, descending);
        this.defineKeyIf(ascInstance, key, SearchSort.Order.ASCENDING);
        this.defineKeyIf(descInstance, key, SearchSort.Order.DESCENDING);
    }

    private void defineKeyIf(boolean condition, String key, SearchSort.Order order) {
        if (key != null && order != null && condition) {
            this.sorterKeys.add(DefaultForumSearchSortManager.getKey(key, order));
        }
    }

    public Set<String> getSorterKeys() {
        return this.sorterKeys;
    }
}

