/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.module.impl;

import com.adaptavist.confluence.forums.model.module.AbstractForumModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public class SearchKeysIndexMapperModuleDescriptor
extends AbstractForumModuleDescriptor {
    private static final String MAPPING = "mapping";
    private static final String INDEX_KEY = "indexKey";
    private static final String SEARCH_KEYS = "searchKeys";
    private Map<String, Set<String>> mappings;

    public SearchKeysIndexMapperModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
        super.init(plugin, element);
        this.assertKeyPresent(element);
        this.assertChildElementPresent(element, MAPPING);
        this.mappings = new HashMap<String, Set<String>>();
        for (Element mapping : this.getChildElements(element, MAPPING)) {
            this.assertKeyPresent(mapping);
            this.assertAttributePresent(mapping, INDEX_KEY);
            this.assertAttributePresent(mapping, SEARCH_KEYS);
            this.defineMapping(mapping);
        }
    }

    private void defineMapping(Element mapping) {
        String indexKey = this.getAttribute(mapping, INDEX_KEY);
        HashSet<String> searchKeys = new HashSet<String>(this.getListAttribute(mapping, SEARCH_KEYS));
        this.mappings.put(indexKey, searchKeys);
    }

    public Map<String, Set<String>> getMappings() {
        return this.mappings;
    }
}

