/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.dao.repository.impl;

import com.adaptavist.confluence.forums.dao.ao.builder.PermissionsConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ForumConfigEntity;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.AbstractConfigRepository;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.atlassian.activeobjects.external.ActiveObjects;
import net.java.ao.DBParam;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPermissionsConfigRepository
extends AbstractConfigRepository
implements PermissionsConfigRepository {
    @Autowired
    public DefaultPermissionsConfigRepository(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    @Override
    public PermissionsConfig getGlobalPermissions() {
        return this.getOrCreateGlobalPermissions();
    }

    @Override
    public PermissionsConfig getSpacePermissions(String spaceKey) {
        PermissionsConfig globalPermissions = this.getGlobalPermissions();
        PermissionsConfig permissionsConfig = this.getSpaceOrGlobalPermissions(spaceKey);
        if (!globalPermissions.isStickySpaceOverride()) {
            permissionsConfig.setStickyPermission(globalPermissions.getStickyPermission());
        }
        if (!globalPermissions.isLockingSpaceOverride()) {
            permissionsConfig.setLockingPermission(globalPermissions.getLockingPermission());
        }
        return permissionsConfig;
    }

    @Override
    public PermissionsConfig.PermissionType getStickyPermissionsForSpace(String spaceKey) {
        return this.getSpacePermissions(spaceKey).getStickyPermission();
    }

    @Override
    public PermissionsConfig.PermissionType getLockingPermissionsForSpace(String spaceKey) {
        return this.getSpacePermissions(spaceKey).getLockingPermission();
    }

    @Override
    public PermissionsConfig saveGlobalPermissions(PermissionsConfigBuilder configBuilder) {
        if (configBuilder == null) {
            return null;
        }
        ForumConfigEntity[] globalPermissions = this.findGlobalPermissions();
        if (globalPermissions.length > 0) {
            this.deleteConfigs(globalPermissions);
        }
        return this.createForumPermissions(configBuilder.toGlobal());
    }

    @Override
    public PermissionsConfig saveSpacePermissions(PermissionsConfigBuilder configBuilder) {
        if (configBuilder == null || StringUtils.isBlank((String)configBuilder.getSpaceKey())) {
            return null;
        }
        String spaceKey = configBuilder.getSpaceKey();
        ForumConfigEntity[] spacePermissions = this.findSpacePermissions(spaceKey);
        if (spacePermissions.length > 0) {
            this.deleteConfigs(spacePermissions);
        }
        return this.createForumPermissions(configBuilder.toSpace(spaceKey));
    }

    private PermissionsConfig getOrCreateGlobalPermissions() {
        PermissionsConfig[] permissions = this.findGlobalPermissions();
        if (permissions.length == 0) {
            return this.createForumPermissions(PermissionsConfigBuilder.defaultGlobalPermissionsBuilder());
        }
        return permissions[0];
    }

    private PermissionsConfig getSpaceOrGlobalPermissions(String spaceKey) {
        PermissionsConfig[] permissions = this.findSpacePermissions(spaceKey);
        if (permissions.length == 0) {
            return this.getOrCreateGlobalPermissions();
        }
        return permissions[0];
    }

    private PermissionsConfig[] findGlobalPermissions() {
        return (PermissionsConfig[])this.findConfigByScopeAndSpace(PermissionsConfig.class, ForumConfigEntity.Scope.GLOBAL, null);
    }

    private PermissionsConfig[] findSpacePermissions(String spaceKey) {
        return (PermissionsConfig[])this.findConfigByScopeAndSpace(PermissionsConfig.class, ForumConfigEntity.Scope.SPACE, spaceKey);
    }

    private PermissionsConfig createForumPermissions(PermissionsConfigBuilder permissions) {
        return this.createConfig(PermissionsConfig.class, this.builderToParams(permissions));
    }

    private DBParam[] builderToParams(PermissionsConfigBuilder permissions) {
        return new DBParam[]{this.param("SCOPE", (Object)permissions.getScope()), this.param("SPACE_KEY", permissions.getSpaceKey()), this.param("STICKY", (Object)permissions.getStickyPermission()), this.param("STICKY_SPACE_OVERRIDE", permissions.isStickySpaceOverride()), this.param("LOCKING", (Object)permissions.getLockingPermission()), this.param("LOCKING_SPACE_OVERRIDE", permissions.isLockingSpaceOverride())};
    }
}

