/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.dao.repository.impl;

import com.adaptavist.confluence.forums.dao.ao.builder.ActivityScoreConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ActivityScoreConfig;
import com.adaptavist.confluence.forums.dao.ao.entity.ForumConfigEntity;
import com.adaptavist.confluence.forums.dao.repository.AbstractConfigRepository;
import com.adaptavist.confluence.forums.dao.repository.ActivityScoreConfigRepository;
import com.atlassian.activeobjects.external.ActiveObjects;
import net.java.ao.DBParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultActivityScoreConfigRepository
extends AbstractConfigRepository
implements ActivityScoreConfigRepository {
    @Autowired
    public DefaultActivityScoreConfigRepository(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    @Override
    public ActivityScoreConfig[] getGlobalActivityScoreConfig() {
        return this.findGlobalActivityScoreConfig();
    }

    @Override
    public ActivityScoreConfig getOrCreateGlobalActivityScoreConfig() {
        ActivityScoreConfig[] activityScoreConfigs = this.findGlobalActivityScoreConfig();
        if (activityScoreConfigs.length == 0) {
            return this.createActivityScoreConfig(ActivityScoreConfigBuilder.defaultGlobalActivityScoreBuilder());
        }
        return activityScoreConfigs[0];
    }

    @Override
    public ActivityScoreConfig getSpaceActivityScoreConfig(String spaceKey) {
        return this.getSpaceOrGlobalPermissions(spaceKey);
    }

    @Override
    public ActivityScoreConfig saveGlobalActivityScoreConfig(ActivityScoreConfigBuilder configBuilder) {
        if (configBuilder == null) {
            return null;
        }
        ForumConfigEntity[] globalActivityScoreConfig = this.findGlobalActivityScoreConfig();
        if (globalActivityScoreConfig.length > 0) {
            this.deleteConfigs(globalActivityScoreConfig);
        }
        return this.createActivityScoreConfig(configBuilder.toGlobal());
    }

    private ActivityScoreConfig getSpaceOrGlobalPermissions(String spaceKey) {
        ActivityScoreConfig[] activityScoreConfigs = this.findSpaceActivityScoreConfig(spaceKey);
        if (activityScoreConfigs.length == 0) {
            activityScoreConfigs = this.getGlobalActivityScoreConfig();
        }
        return activityScoreConfigs[0];
    }

    private ActivityScoreConfig[] findGlobalActivityScoreConfig() {
        return (ActivityScoreConfig[])this.findConfigByScopeAndSpace(ActivityScoreConfig.class, ForumConfigEntity.Scope.GLOBAL, null);
    }

    private ActivityScoreConfig[] findSpaceActivityScoreConfig(String spaceKey) {
        return (ActivityScoreConfig[])this.findConfigByScopeAndSpace(ActivityScoreConfig.class, ForumConfigEntity.Scope.SPACE, spaceKey);
    }

    private ActivityScoreConfig createActivityScoreConfig(ActivityScoreConfigBuilder configBuilder) {
        return this.createConfig(ActivityScoreConfig.class, this.builderToParams(configBuilder));
    }

    private DBParam[] builderToParams(ActivityScoreConfigBuilder activityScore) {
        return new DBParam[]{this.param("SCOPE", (Object)activityScore.getScope()), this.param("SPACE_KEY", activityScore.getSpaceKey()), this.param("EDIT_MULTIPLIER", activityScore.getEditMultiplier()), this.param("COMMENT_MULTIPLIER", activityScore.getCommentMultiplier()), this.param("ATTACH_MULTIPLIER", activityScore.getAttachmentMultiplier()), this.param("AGE_MULTIPLIER", (Object)activityScore.getContentAge())};
    }
}

