/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners.handler.impl.util;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.Set;

public class ForumFlagCreator {
    private final ForumManager forumManager;
    private final PageStatusManager pageStatusManager;

    public ForumFlagCreator(ForumManager forumManager, PageStatusManager pageStatusManager) {
        this.forumManager = forumManager;
        this.pageStatusManager = pageStatusManager;
    }

    public void createForumFlags(Page page, Set<PageSpaceParam> forumPageParams) {
        for (PageSpaceParam forumPageParam : forumPageParams) {
            Page forumPage = forumPageParam.getPage();
            if (this.forumManager.isForum(forumPage) || !this.forumManager.hasCreateForumPermission((User)AuthenticatedUserThreadLocal.get(), forumPage)) continue;
            this.forumManager.createForum(forumPage);
            this.forumManager.addIndexReference(forumPage, page);
        }
    }

    public void removeForumFlags(Page page, Set<PageSpaceParam> forumPageParams) {
        for (PageSpaceParam forumPageParam : forumPageParams) {
            Page forumPage = forumPageParam.getPage();
            if (!this.forumManager.isForum(forumPage) || !this.forumManager.hasCreateForumPermission((User)AuthenticatedUserThreadLocal.get(), forumPage)) continue;
            this.forumManager.removeIndexReference(forumPage, page);
            if (this.forumManager.hasIndexReference(forumPage)) continue;
            this.pageStatusManager.removeAllForumProperties(forumPage);
        }
    }
}

