/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners.handler.impl;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.PageEventAbstractStrategy;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.util.ForumFlagCreator;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.util.ForumPagesExtractor;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.adaptavist.confluence.forums.view.macros.params.ParamsParser;
import com.adaptavist.confluence.forums.view.macros.parser.MacroDefinitionParser;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpdatePageEventStrategy
extends PageEventAbstractStrategy<PageUpdateEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatePageEventStrategy.class);
    private final MacroDefinitionParser macroDefinitionParser;
    private final ForumPagesExtractor forumPagesExtractor;
    private final ForumFlagCreator forumFlagCreator;

    public UpdatePageEventStrategy(MacroDefinitionParser macroDefinitionParser, ParamsParser paramsParser, ForumManager forumManager, PageStatusManager pageStatusManager) {
        this.macroDefinitionParser = macroDefinitionParser;
        this.forumPagesExtractor = new ForumPagesExtractor(paramsParser);
        this.forumFlagCreator = new ForumFlagCreator(forumManager, pageStatusManager);
    }

    @Override
    public void processPageEvent(PageUpdateEvent pageEvent) {
        AbstractPage originalPage = pageEvent.getOriginalPage();
        Page newPage = this.getPage((PageEvent)pageEvent);
        if (originalPage instanceof Page) {
            this.addOrRemoveForumFlagsAfterUpdatePageEvent((Page)originalPage, newPage);
        }
    }

    private void addOrRemoveForumFlagsAfterUpdatePageEvent(Page originalPage, Page newPage) {
        List<MacroDefinition> oldMacroDefinitions = this.macroDefinitionParser.parseMacroDefinitions(originalPage, ForumConstants.ForumMacro.FORUM);
        List<MacroDefinition> newMacroDefinitions = this.macroDefinitionParser.parseMacroDefinitions(newPage, ForumConstants.ForumMacro.FORUM);
        Set<PageSpaceParam> oldForumMacroPages = this.forumPagesExtractor.getForumMacroPages(newPage, oldMacroDefinitions);
        Set<PageSpaceParam> oldRootPages = this.forumPagesExtractor.getForumRootPages(newPage, oldMacroDefinitions);
        Set<PageSpaceParam> currentRootPages = this.forumPagesExtractor.getForumRootPages(newPage, newMacroDefinitions);
        this.forumFlagCreator.createForumFlags(newPage, (Set<PageSpaceParam>)Sets.difference(currentRootPages, oldRootPages));
        if (Sets.difference(currentRootPages, oldRootPages).size() > 0) {
            LOG.info("Forum flags added after page " + newPage.getId() + " has been updated");
        }
        if (oldMacroDefinitions.size() > 0 && newMacroDefinitions.size() == 0) {
            this.forumFlagCreator.removeForumFlags(newPage, oldForumMacroPages);
            this.forumFlagCreator.removeForumFlags(newPage, (Set<PageSpaceParam>)Sets.difference(oldRootPages, currentRootPages));
            LOG.info("Forum flags removed after page " + newPage.getId() + " has been updated");
        }
    }
}

