/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentReindexPageListener
implements EventListener {
    protected static final Class[] HANDLED_EVENTS = new Class[]{CommentCreateEvent.class, CommentRemoveEvent.class, CommentUpdateEvent.class};
    private static final Logger LOG = LoggerFactory.getLogger(CommentReindexPageListener.class);
    private ConfluenceIndexer indexer;

    public CommentReindexPageListener(ConfluenceIndexer indexer) {
        this.indexer = indexer;
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    public void handleEvent(Event event) {
        if (event instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)event;
            if (LOG.isDebugEnabled()) {
                LOG.debug("caught event: " + commentEvent);
            }
            ContentEntityObject ceo = commentEvent.getComment().getContainer();
            this.indexer.reIndex((Searchable)ceo);
        }
    }
}

