/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.sticky;

import com.adaptavist.confluence.forums.controller.action.AbstractPageAwareAction;
import com.adaptavist.confluence.forums.service.StickyPageManager;
import com.atlassian.user.User;

public class StickyTopicAction
extends AbstractPageAwareAction {
    private StickyPageManager stickyPageManager;

    public String markTopicAsSticky() {
        if (this.hasUpdateStickyPermissions()) {
            this.stickyPageManager.markPageAsSticky(this.getPage());
            return "success";
        }
        return "error";
    }

    public String removeStickyForTopic() {
        if (this.hasUpdateStickyPermissions()) {
            this.stickyPageManager.removeStickyForPage(this.getPage());
            return "success";
        }
        return "error";
    }

    private boolean hasUpdateStickyPermissions() {
        if (this.getPage() == null) {
            this.addActionError(this.getText("com.adaptavist.confluence.restforum.action.sticky.page.not.specified"));
            return false;
        }
        if (!this.stickyPageManager.hasUpdateStickyPermission((User)this.getAuthenticatedUser(), this.getPage())) {
            this.addActionError(this.getText("com.adaptavist.confluence.restforum.action.sticky.no.permission"));
            return false;
        }
        return true;
    }

    public void setStickyPageManager(StickyPageManager stickyPageManager) {
        this.stickyPageManager = stickyPageManager;
    }
}

