/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.sort.comparator;

import com.atlassian.confluence.pages.NaturalStringComparator;
import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class TitleFieldComparator
extends FieldComparator<BytesRefBuilder> {
    private final Comparator<String> comparator;
    private final String field;
    private final BytesRefBuilder tempBR = new BytesRefBuilder();
    private BytesRefBuilder[] values;
    private BinaryDocValues docTerms;
    private BytesRefBuilder bottom;

    public TitleFieldComparator(int numHits, String field) {
        this.comparator = new NaturalStringComparator();
        this.values = new BytesRefBuilder[numHits];
        this.field = field;
        for (int i = 0; i < numHits; ++i) {
            this.values[i] = new BytesRefBuilder();
        }
    }

    public int compare(int slot1, int slot2) {
        BytesRefBuilder val1 = this.values[slot1];
        BytesRefBuilder val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.naturalStringComparison(val1, val2);
    }

    public int compareBottom(int doc) throws IOException {
        if (this.docTerms.advanceExact(doc)) {
            this.tempBR.copyBytes(this.docTerms.binaryValue());
            return this.naturalStringComparison(this.bottom, this.tempBR);
        }
        return this.bottom.length() == 0 ? 0 : -1;
    }

    public void copy(int slot, int doc) throws IOException {
        if (this.docTerms.advanceExact(doc)) {
            this.values[slot].copyBytes(this.docTerms.binaryValue());
        } else {
            this.values[slot].clear();
        }
    }

    public FieldComparator<BytesRefBuilder> setNextReader(LeafReaderContext context) throws IOException {
        this.docTerms = context.reader().getBinaryDocValues(this.field);
        return this;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public BytesRefBuilder value(int slot) {
        return this.values[slot];
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        this.setNextReader(context);
        return new LeafFieldComparator(){

            public int compareBottom(int doc) throws IOException {
                return TitleFieldComparator.this.compareBottom(doc);
            }

            public void copy(int slot, int doc) throws IOException {
                TitleFieldComparator.this.copy(slot, doc);
            }

            public void setScorer(Scorable scorable) throws IOException {
            }

            public void setBottom(int slot) {
                TitleFieldComparator.this.setBottom(slot);
            }

            public int compareTop(int doc) throws IOException {
                return 0;
            }
        };
    }

    public int compareValues(BytesRefBuilder val1, BytesRefBuilder val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.naturalStringComparison(val1, val2);
    }

    public int compareDocToValue(int doc, BytesRefBuilder value) throws IOException {
        if (this.docTerms.advanceExact(doc)) {
            this.tempBR.copyBytes(this.docTerms.binaryValue());
            return this.naturalStringComparison(this.tempBR, value);
        }
        return -1;
    }

    private int naturalStringComparison(BytesRefBuilder bytesRef1, BytesRefBuilder bytesRef2) {
        String val1 = this.bytesRefToString(bytesRef1);
        String val2 = this.bytesRefToString(bytesRef2);
        return this.comparator.compare(val1, val2);
    }

    private String bytesRefToString(BytesRefBuilder bytesRef) {
        if (bytesRef.length() > 0) {
            return bytesRef.toBytesRef().utf8ToString();
        }
        return "";
    }
}

