/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.service.search.criteria.SearchKeyFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchKeyFinder
implements SearchKeyFinder {
    private static final Pattern FIND_SEARCH_KEYS = Pattern.compile("([\\s\\(]*|^[\\s\\(]*)([a-zA-Z]+)(\\s*:)");
    private static final Integer FIND_SEARCH_KEYS_GROUP = 2;

    @Override
    public Set<String> findSearchKeys(String searchQuery) {
        if (StringUtils.isNotBlank((String)searchQuery)) {
            HashSet<String> searchKeys = new HashSet<String>();
            Matcher matcher = FIND_SEARCH_KEYS.matcher(searchQuery);
            while (matcher.find()) {
                searchKeys.add(matcher.group(FIND_SEARCH_KEYS_GROUP));
            }
            return searchKeys;
        }
        return Collections.emptySet();
    }
}

