/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.filter;

import com.adaptavist.confluence.forums.controller.filter.resolver.RequestActionResolver;
import com.adaptavist.confluence.forums.controller.filter.resolver.RequestPageResolver;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.confluence.pages.AbstractPage;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractLockedPageServletFilter
implements Filter {
    public static final String LOCKED_ACTION = "locked-action";
    private String lockedAction;
    private ForumManager forumManager;
    private RequestPageResolver requestPageResolver;
    private RequestActionResolver requestActionResolver;

    public AbstractLockedPageServletFilter(ForumManager forumManager, RequestPageResolver requestPageResolver, RequestActionResolver requestActionResolver) {
        this.forumManager = forumManager;
        this.requestPageResolver = requestPageResolver;
        this.requestActionResolver = requestActionResolver;
    }

    public void init(FilterConfig filterConfig) {
        this.lockedAction = filterConfig.getInitParameter(LOCKED_ACTION);
        if (StringUtils.isBlank((String)this.lockedAction)) {
            throw new IllegalArgumentException("Locked action name missing (init param 'locked-action')");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean lockedPageFilterChain = false;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            String contextPath = request.getContextPath();
            AbstractPage page = this.requestPageResolver.resolvePage(request);
            if (this.forumManager.isPageLocked(page)) {
                lockedPageFilterChain = this.doFilterLockedPage(response, page, contextPath);
            }
        }
        if (!lockedPageFilterChain) {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    protected abstract boolean doFilterLockedPage(HttpServletResponse var1, AbstractPage var2, String var3) throws IOException;

    public void destroy() {
        this.requestPageResolver = null;
        this.requestActionResolver = null;
        this.forumManager = null;
    }

    protected String getLockedAction() {
        return this.lockedAction;
    }

    protected String getViewLockedPageActionPath(AbstractPage page, String contextPath) {
        return this.requestActionResolver.resolveViewLockedPageActionUrl(page, contextPath);
    }

    protected String getLockedPageActionPath(AbstractPage page, String contextPath) {
        return this.requestActionResolver.resolveLockedPageActionUrl(page, contextPath, this.getLockedAction());
    }
}

