import { themes, buttonThemeNamespace } from 'adaptavist-components'
import { themed, colors } from '@atlaskit/theme';
import color from 'color'
import { AJS } from './utils'

export const theme = {
    textColor: themes.common.black,

    productTitleBarBackgroundColor: themes.products.royal,
    productTitleBarTextColor: themes.products.white,
    supportBoxBackgroundColor: 'red',
    sectionHeaderFontSize: '20px',
    learnMoreCardBorderColor: themes.products.brand,
    learnMoreBoxMargin: '5em 0 0 0',

    primary: createAtlaskitTheme(themes.products.gold),
    default: createAtlaskitTheme(themes.products.azure)
}

// For buttons
theme[buttonThemeNamespace] = theme;


// Util
function createAtlaskitTheme(baseColor) {
    return {
        background: {
            default: baseColor, disabled: baseColor, selected: baseColor,
            hover: color(baseColor).lighten(0.2).string(),
            active: color(baseColor).darken(0.1).string(),
        },
        boxShadowColor: { focus: themes.common.black },
        color: {
            default: themes.common.white,
            disabled: themes.common.white,
            selected: themes.common.white,
        },
    }
}
