/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.parser.impl;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.view.macros.parser.MacroDefinitionParser;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMacroDefinitionParser
implements MacroDefinitionParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMacroDefinitionParser.class);
    private final XhtmlContent xhtmlContent;

    @Autowired
    public DefaultMacroDefinitionParser(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    @Override
    public List<MacroDefinition> parseAllMacroDefinitions(Page page) {
        return this.parseAllMacroDefinitions(this.getPageContent(page));
    }

    @Override
    public List<MacroDefinition> parseMacroDefinitions(Page page, ForumConstants.ForumMacro macro) {
        return this.parseMacroDefinitions(this.getPageContent(page), macro);
    }

    @Override
    public List<MacroDefinition> parseAllMacroDefinitions(String content) {
        return this.parseMacroDefinitions(content, null);
    }

    @Override
    public List<MacroDefinition> parseMacroDefinitions(String pageContent, ForumConstants.ForumMacro macro) {
        return this.parseMacroDefinitionsFor(pageContent, macro);
    }

    private List<MacroDefinition> parseMacroDefinitionsFor(String pageContent, ForumConstants.ForumMacro forumMacro) {
        ArrayList<MacroDefinition> macroDefinitions = new ArrayList<MacroDefinition>();
        if (StringUtils.isNotBlank((String)pageContent)) {
            this.parseAndCollectMacroDefinitions(pageContent, forumMacro, macroDefinitions);
        }
        return macroDefinitions;
    }

    private void parseAndCollectMacroDefinitions(String content, ForumConstants.ForumMacro macro, List<MacroDefinition> collector) {
        ForumMacroDefinitionHandler definitionHandler = new ForumMacroDefinitionHandler(macro, collector);
        DefaultConversionContext conversionContext = new DefaultConversionContext(new RenderContext());
        try {
            this.xhtmlContent.handleMacroDefinitions(content, (ConversionContext)conversionContext, (MacroDefinitionHandler)definitionHandler);
        }
        catch (XhtmlException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse macro definitions from content: " + content, (Throwable)e);
        }
    }

    private String getPageContent(Page page) {
        return page == null ? null : page.getBodyAsString();
    }

    private static class ForumMacroDefinitionHandler
    implements MacroDefinitionHandler {
        private final ForumConstants.ForumMacro filteredMacro;
        private final List<MacroDefinition> macroDefinitionsCollector;

        private ForumMacroDefinitionHandler(ForumConstants.ForumMacro filteredMacro, List<MacroDefinition> macroDefinitionsCollector) {
            this.filteredMacro = filteredMacro;
            this.macroDefinitionsCollector = macroDefinitionsCollector;
        }

        public void handle(MacroDefinition macroDefinition) {
            ForumConstants.ForumMacro macro = ForumConstants.ForumMacro.fromMacroName(macroDefinition.getName());
            if (this.filteredMacro == null || this.filteredMacro.equals((Object)macro)) {
                this.macroDefinitionsCollector.add(macroDefinition);
            }
        }
    }
}

