/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.column.generic;

import com.adaptavist.confluence.forums.model.datatypes.DataItemType;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeFormatter;
import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.model.datatypes.PredefinedFormat;
import com.adaptavist.confluence.forums.view.macros.column.generic.model.Column;
import com.adaptavist.confluence.forums.view.macros.column.generic.model.Columns;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.TransformerUrlBuilder;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericColumnMacroDataTransformer
implements WebResourceTransformerFactory {
    public static final String MARKER = "['\"]com.adaptavist.forums:column.data['\"]";
    private static final String COLUMN_NAME = "com.adaptavist.forum.generic.columnname.";
    private static final String FORMATTER_NAME = "com.adaptavist.forum.generic.formattername.";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DataTypeManager dataTypeManager;
    private final I18nResolver i18nResolver;

    public GenericColumnMacroDataTransformer(DataTypeManager dataTypeManager, I18nResolver i18nResolver) {
        this.dataTypeManager = dataTypeManager;
        this.i18nResolver = i18nResolver;
    }

    private String getText(String prefix, String name) {
        String columnName = this.i18nResolver.getText(prefix + name);
        if (columnName.startsWith(prefix)) {
            return name;
        }
        return columnName;
    }

    private Map<String, String> getFormatterMap(DataTypeFormatter formatter) {
        HashMap<String, String> fomatterMap = new HashMap<String, String>();
        for (PredefinedFormat predefinedFormat : formatter.getPredefinedFormats()) {
            fomatterMap.put(predefinedFormat.getId(), this.getText(FORMATTER_NAME, predefinedFormat.getId()));
        }
        return fomatterMap;
    }

    private Columns convertToColumns(Collection<DataItemType> dataItemTypes) {
        HashMap<String, Column> columns = new HashMap<String, Column>();
        for (DataItemType dataItemType : dataItemTypes) {
            DataTypeFormatter formatter = this.dataTypeManager.getDataTypeFormatter(dataItemType.getFormatterName());
            Column column = new Column(this.getText(COLUMN_NAME, dataItemType.getName()), this.i18nResolver.getText(dataItemType.getDefaultHeading()), this.getFormatterMap(formatter));
            columns.put(dataItemType.getName(), column);
        }
        return new Columns(columns);
    }

    public TransformerUrlBuilder makeUrlBuilder(TransformerParameters parameters) {
        return urlBuilder -> {};
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters parameters) {
        return (transformableResource, params) -> new CharSequenceDownloadableResource(transformableResource.nextResource()){

            protected CharSequence transform(CharSequence charSequence) {
                Columns columns = GenericColumnMacroDataTransformer.this.convertToColumns(GenericColumnMacroDataTransformer.this.dataTypeManager.getDataItemTypes());
                try {
                    String jsonString = new ObjectMapper().writer().writeValueAsString((Object)columns);
                    return charSequence.toString().replaceAll(GenericColumnMacroDataTransformer.MARKER, jsonString);
                }
                catch (IOException e) {
                    GenericColumnMacroDataTransformer.this.log.error("Failed to serialise server list: {0},", (Object)e.getMessage(), (Object)e);
                    return charSequence;
                }
            }
        };
    }
}

