/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans.search.topics;

import com.adaptavist.confluence.forums.view.beans.search.topics.Filter;
import com.adaptavist.confluence.forums.view.beans.search.topics.SortOrder;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import java.util.Set;

public class TopicSearchCriteriaBuilder {
    private final String forumId;
    private boolean includeSubTopics;
    private String searchText;
    private Set<String> searchKeys;
    private Set<Filter> filters;
    private String sortKey;
    private SortOrder sortOrder;
    private boolean sortStickyOnTop;
    private int startIndex;
    private int pageSize;
    private Set<String> dataItemNames;

    private TopicSearchCriteriaBuilder(String forumId) {
        this.forumId = forumId;
    }

    public static TopicSearchCriteriaBuilder topicCriteriaBuilder(long forumId) {
        return new TopicSearchCriteriaBuilder(String.valueOf(forumId));
    }

    public static TopicSearchCriteriaBuilder topicCriteriaBuilder(String forumId) {
        return new TopicSearchCriteriaBuilder(forumId);
    }

    public TopicSearchCriteriaBuilder includeSubTopics(boolean includeSubTopics) {
        this.includeSubTopics = includeSubTopics;
        return this;
    }

    public TopicSearchCriteriaBuilder searchText(String searchText) {
        this.searchText = searchText;
        return this;
    }

    public TopicSearchCriteriaBuilder searchKeys(Set<String> searchKeys) {
        this.searchKeys = searchKeys;
        return this;
    }

    public TopicSearchCriteriaBuilder filters(Set<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public TopicSearchCriteriaBuilder sortKey(String sortKey) {
        this.sortKey = sortKey;
        return this;
    }

    public TopicSearchCriteriaBuilder sortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public TopicSearchCriteriaBuilder sortStickyOnTop(boolean sortStickyOnTop) {
        this.sortStickyOnTop = sortStickyOnTop;
        return this;
    }

    public TopicSearchCriteriaBuilder startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public TopicSearchCriteriaBuilder pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public TopicSearchCriteriaBuilder maxPageSize() {
        this.pageSize = Integer.MAX_VALUE;
        return this;
    }

    public TopicSearchCriteriaBuilder dataItemNames(Set<String> dataItemNames) {
        this.dataItemNames = dataItemNames;
        return this;
    }

    public TopicSearchCriteria build() {
        boolean includeLockedTopics = false;
        boolean includeUnlockedTopics = false;
        boolean includeUserFollows = false;
        boolean includeHotTopics = false;
        boolean searchComments = true;
        boolean includeWatchedTopics = false;
        String includeTopicsCreatedByUser = "";
        String activityIndicatorThreshold = "";
        return new TopicSearchCriteria(this.forumId, this.includeSubTopics, includeUnlockedTopics, includeLockedTopics, includeWatchedTopics, includeHotTopics, includeTopicsCreatedByUser, activityIndicatorThreshold, this.searchText, this.searchKeys, this.filters, this.sortKey, this.sortOrder != null ? this.sortOrder.name() : SortOrder.DESC.name(), this.sortStickyOnTop, this.startIndex, this.pageSize, this.dataItemNames, searchComments);
    }
}

