/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation;

import com.adaptavist.confluence.forums.service.validation.ValidationFlow;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.impl.LockingPageValidator;
import com.adaptavist.confluence.forums.service.validation.impl.MakeStickyPageValidator;
import com.adaptavist.confluence.forums.service.validation.impl.ViewPageStatusValidator;
import com.atlassian.confluence.pages.AbstractPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForumStatusValidationManager {
    private final LockingPageValidator lockingPageValidator;
    private final MakeStickyPageValidator makeStickyPageValidator;
    private final ViewPageStatusValidator viewPageStatusValidator;

    @Autowired
    public ForumStatusValidationManager(LockingPageValidator lockingValidator, MakeStickyPageValidator stickyValidator, ViewPageStatusValidator viewPageStatusValidator) {
        this.lockingPageValidator = lockingValidator;
        this.makeStickyPageValidator = stickyValidator;
        this.viewPageStatusValidator = viewPageStatusValidator;
    }

    public ValidationReport validateUpdateStickyAction(AbstractPage page) {
        return ValidationFlow.validationFlow().validate(page).with(this.makeStickyPageValidator).andReport();
    }

    public ValidationReport validateUpdateLockingAction(AbstractPage page) {
        return ValidationFlow.validationFlow().validate(page).with(this.lockingPageValidator).andReport();
    }

    public ValidationReport validateViewPageStatusAction(AbstractPage page) {
        return ValidationFlow.validationFlow().validate(page).with(this.viewPageStatusValidator).andReport();
    }
}

