/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.query;

import com.adaptavist.confluence.forums.service.search.query.AbstractForumsQuery;
import com.adaptavist.confluence.forums.service.search.query.range.ForumStringRange;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.LongRangeQuery;
import com.google.common.collect.ImmutableList;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public abstract class ForumStringRangeQuery<T extends AbstractForumsQuery, RangeType>
implements SearchQuery {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private final String key;
    private final ForumStringRange range;

    protected ForumStringRangeQuery(String key, ForumStringRange range) {
        this.range = range;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public List<?> getParameters() {
        return ImmutableList.of((Object)this.range);
    }

    public ForumStringRange getRange() {
        return this.range;
    }

    public static ForumStringRange filterRange(List<String> filterValues, FilterValueType valueType) {
        if (!CollectionUtils.isEmpty(filterValues) && valueType != null) {
            switch (valueType) {
                case SIMPLE: {
                    return ForumStringRange.range(filterValues.get(0));
                }
                case RANGE: {
                    return ForumStringRange.range(filterValues.get(0), filterValues.get(1));
                }
            }
        }
        return ForumStringRange.emptyRange();
    }

    public LongRangeQuery longRangeQuery(Long start, Long end) {
        return new LongRangeQuery(this.getIndexField(), Range.range((Object)start, (Object)end, (boolean)true, (boolean)false));
    }

    protected abstract String getIndexField();

    protected abstract RangeType processRangeStart(String var1);

    protected abstract RangeType processRangeEnd(String var1);

    protected abstract SearchQuery buildRangeQuery(RangeType var1, RangeType var2);

    private SearchQuery getQuery(RangeType start, RangeType end) {
        if (start == null && end == null) {
            return null;
        }
        return this.buildRangeQuery(start, end);
    }

    protected Long getNextDayDateToMillis(String dateAsString) {
        Date date = this.getNextDay(dateAsString);
        return date == null ? null : Long.valueOf(date.getTime());
    }

    protected Long getDateToMillis(String dateAsString) {
        Date date = this.getDate(dateAsString);
        return date == null ? null : Long.valueOf(date.getTime());
    }

    private Date getNextDay(String dateAsString) {
        Date date = this.getDate(dateAsString);
        return date == null ? null : new Date(date.getTime() + 86400000L);
    }

    private Date getDate(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        try {
            return DATE_FORMAT.parse(dateAsString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public SearchQuery expand() {
        if (this.range == null) {
            return null;
        }
        RangeType rangeStart = this.processRangeStart(this.range.getStart());
        RangeType rangeEnd = this.processRangeEnd(this.range.getEnd());
        return this.getQuery(rangeStart, rangeEnd);
    }
}

