/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.service.search.SearchKeyIndexResolver;
import com.adaptavist.confluence.forums.service.search.criteria.SearchKeyFinder;
import com.adaptavist.confluence.forums.service.search.criteria.SearchQueryTranslator;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultSearchQueryTranslator
implements SearchQueryTranslator {
    private static final String[] SINGLE_SPECIAL_CHARS = new String[]{"", "*", "?", "!"};
    private static final String SEARCH_KEY_REPLACE = "([\\s\\(]*|^[\\s\\(]*)(%s)(\\s*:)";
    private static final String INDEX_KEY_REPLACEMENT = "$1%s$3";
    private final SearchKeyFinder searchKeyFinder;
    private final SearchKeyIndexResolver indexResolver;

    @Autowired
    public DefaultSearchQueryTranslator(SearchKeyFinder searchKeyFinder, SearchKeyIndexResolver indexResolver) {
        this.searchKeyFinder = searchKeyFinder;
        this.indexResolver = indexResolver;
    }

    @Override
    public String translateQuery(String searchQuery) {
        String queryTranslation = StringUtils.trim((String)searchQuery);
        if (StringUtils.isBlank((String)queryTranslation) || this.isOneOf(queryTranslation, SINGLE_SPECIAL_CHARS)) {
            return null;
        }
        return this.translateQuerySearchKeys(queryTranslation);
    }

    @Override
    public Set<String> translateSearchKeys(Set<String> searchKeys) {
        if (CollectionUtils.isNotEmpty(searchKeys) && this.indexResolver.hasIndexes(searchKeys)) {
            return this.indexResolver.resolveIndexes(searchKeys);
        }
        return Collections.emptySet();
    }

    private String translateQuerySearchKeys(String searchQuery) {
        String searchQueryTranslation = searchQuery;
        Set<String> querySearchKeys = this.searchKeyFinder.findSearchKeys(searchQueryTranslation);
        for (String searchKey : querySearchKeys) {
            searchQueryTranslation = this.replaceSearchKeyWithIndexKey(searchQueryTranslation, searchKey);
        }
        return this.appendStarAtTheEnd(searchQueryTranslation);
    }

    private String appendStarAtTheEnd(String searchQueryTranslation) {
        String lastCharacter = searchQueryTranslation.substring(searchQueryTranslation.length() - 1);
        if (lastCharacter.equals(")")) {
            return searchQueryTranslation;
        }
        return searchQueryTranslation + "*";
    }

    private String replaceSearchKeyWithIndexKey(String searchQueryTranslated, String searchKey) {
        if (StringUtils.isNotBlank((String)searchKey) && this.indexResolver.hasIndex(searchKey)) {
            String index = this.indexResolver.resolveIndex(searchKey);
            String searchKeyReplace = String.format(SEARCH_KEY_REPLACE, searchKey);
            String indexKeyReplacement = String.format(INDEX_KEY_REPLACEMENT, index);
            return searchQueryTranslated.replaceAll(searchKeyReplace, indexKeyReplacement);
        }
        return searchQueryTranslated;
    }

    private boolean isOneOf(String value, String ... inValues) {
        for (String val : inValues) {
            if (!val.equalsIgnoreCase(value.trim())) continue;
            return true;
        }
        return false;
    }
}

