/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.forums.service.ActivityScoreManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PluginEnabledEventListener
implements InitializingBean,
DisposableBean {
    private final ActivityScoreManager activityScoreManager;
    private final EventPublisher eventPublisher;

    public PluginEnabledEventListener(ActivityScoreManager activityScoreManager, EventPublisher eventPublisher) {
        this.activityScoreManager = activityScoreManager;
        this.eventPublisher = eventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
        String startUpPluginKey = pluginEnabledEvent.getPlugin().getKey();
        if ("com.adaptavist.confluence.forums".equals(startUpPluginKey)) {
            this.checkOrCreateGlobalConfig();
        }
    }

    private void checkOrCreateGlobalConfig() {
        if (!this.activityScoreManager.hasGlobalActivityScoreConfig()) {
            this.activityScoreManager.createGlobalActivityScoreConfig();
        }
    }
}

