/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.converter.json.JsonConverter;
import com.adaptavist.confluence.forums.controller.listeners.ForumsCacheName;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.pages.AbstractPage;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ForumsTopicViewsCacheManager {
    private static final String FORUMS_TOPIC_VIEWS_CACHE = ForumsCacheName.TOPIC_VIEWS.getCacheName();
    private static final String ZERO = "0";
    private static final Type TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static Cache<String, String> cache;

    public ForumsTopicViewsCacheManager(CacheManager cacheManager) {
        if (cache == null) {
            cache = cacheManager.getCache(FORUMS_TOPIC_VIEWS_CACHE, null, new CacheSettingsBuilder().expireAfterAccess(3L, TimeUnit.DAYS).build());
        }
    }

    public String getCachedViews(AbstractPage abstractPage) {
        return this.extractCacheViews(abstractPage);
    }

    public void addViewToCache(AbstractPage abstractPage) {
        Map<String, String> topicViewMap = this.getCachedViewsMap();
        String cachedViews = this.getCachedViews(abstractPage, topicViewMap);
        int newView = Integer.parseInt(cachedViews) + 1;
        topicViewMap.put(abstractPage.getIdAsString(), Integer.toString(newView));
        String jsonUpdatedCachedMap = JsonConverter.toJson(topicViewMap, (Type)TYPE);
        cache.put((Object)FORUMS_TOPIC_VIEWS_CACHE, (Object)jsonUpdatedCachedMap);
    }

    public void clearCachedViews(AbstractPage abstractPage) {
        Map<String, String> topicViewMap = this.getCachedViewsMap();
        topicViewMap.put(abstractPage.getIdAsString(), ZERO);
        String jsonUpdatedCachedMap = JsonConverter.toJson(topicViewMap, (Type)TYPE);
        cache.put((Object)FORUMS_TOPIC_VIEWS_CACHE, (Object)jsonUpdatedCachedMap);
    }

    public Cache<String, String> getCache() {
        return cache;
    }

    private Map<String, String> getCachedViewsMap() {
        String jsonCachedMap = (String)cache.get((Object)FORUMS_TOPIC_VIEWS_CACHE);
        Map topicViewMap = (Map)JsonConverter.fromJson((String)jsonCachedMap, (Type)TYPE);
        return topicViewMap == null ? new HashMap() : topicViewMap;
    }

    private String getCachedViews(AbstractPage abstractPage, Map<String, String> topicViewMap) {
        String abstractPageId = abstractPage.getIdAsString();
        return topicViewMap.get(abstractPageId) != null ? topicViewMap.get(abstractPageId) : ZERO;
    }

    private String extractCacheViews(AbstractPage abstractPage) {
        return this.getCachedViews(abstractPage, this.getCachedViewsMap());
    }
}

