/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.adaptavist.confluence.forums.view.beans.search.topics.Filter;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SearchFilterCriteriaValidator
implements Validator<Set<Filter>> {
    public static final Set<String> ALLOWED_FILTER_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("creationdate", "lastactivitydate", "createdby", "forumIndexPageIsLocked")));

    @Override
    public ValidationReport validate(Set<Filter> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return ValidationReport.success();
        }
        for (Filter filter : filters) {
            if (filter == null) {
                return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"filter"});
            }
            String filterKey = filter.getKey();
            List<String> filterValues = filter.getValues();
            FilterValueType valueType = filter.getValueType();
            if (StringUtils.isBlank((String)filterKey) || !ALLOWED_FILTER_KEYS.contains(filterKey)) {
                return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"filter key"});
            }
            if (CollectionUtils.isEmpty(filterValues)) {
                return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"filter values"});
            }
            if ((!FilterValueType.SIMPLE.equals((Object)valueType) || filterValues.size() == 1) && (!FilterValueType.RANGE.equals((Object)valueType) || filterValues.size() == 2)) continue;
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"filter valueType"});
        }
        return ValidationReport.success();
    }
}

